/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Scanner;
import me.block2block.hubparkour.HubParkourAPIImpl;
import me.block2block.hubparkour.api.BackendAPI;
import me.block2block.hubparkour.api.plates.PressurePlate;
import me.block2block.hubparkour.bukkit.Metrics;
import me.block2block.hubparkour.commands.CommandParkour;
import me.block2block.hubparkour.commands.ParkourTabComplete;
import me.block2block.hubparkour.entities.HubParkourPlayer;
import me.block2block.hubparkour.entities.LeaderboardHologram;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.listeners.BreakListener;
import me.block2block.hubparkour.listeners.CommandListener;
import me.block2block.hubparkour.listeners.DropListener;
import me.block2block.hubparkour.listeners.ElytraListener;
import me.block2block.hubparkour.listeners.FallListener;
import me.block2block.hubparkour.listeners.FlyListener;
import me.block2block.hubparkour.listeners.ItemClickListener;
import me.block2block.hubparkour.listeners.LeaveListener;
import me.block2block.hubparkour.listeners.MountListener;
import me.block2block.hubparkour.listeners.PotionListener;
import me.block2block.hubparkour.listeners.PressurePlateListener;
import me.block2block.hubparkour.listeners.SetupListener;
import me.block2block.hubparkour.listeners.SignListener;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.managers.DatabaseManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import me.block2block.hubparkour.utils.HubParkourExpansion;
import me.block2block.hubparkour.utils.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HubParkour
extends JavaPlugin {
    private static HubParkour instance;
    private static boolean holograms;
    private static boolean placeholders;
    private static DatabaseManager dbManager;
    private static boolean pre1_13;
    private static boolean post1_8;
    private static boolean post1_9;

    public void onEnable() {
        File configFile;
        instance = this;
        BackendAPI.setImplementation(new HubParkourAPIImpl());
        new Metrics(this, 14109);
        switch (Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]) {
            case "v1_12_R1": 
            case "v1_11_R1": 
            case "v1_10_R1": {
                post1_9 = true;
            }
            case "v1_9_R1": 
            case "v1_9_R2": {
                Bukkit.getPluginManager().registerEvents((Listener)new ElytraListener(), (Plugin)this);
                this.getLogger().info("Legacy server version detected (1.8-1.12).");
                pre1_13 = true;
                post1_8 = true;
                break;
            }
            case "v1_8_R1": 
            case "v1_8_R2": 
            case "v1_8_R3": {
                this.getLogger().info("Legacy server version detected (1.8-1.12).");
                pre1_13 = true;
                post1_8 = false;
                break;
            }
            default: {
                pre1_13 = false;
                post1_8 = true;
                post1_9 = true;
                this.getLogger().info("1.13+ server version detected.");
                Bukkit.getPluginManager().registerEvents((Listener)new ElytraListener(), (Plugin)this);
                Bukkit.getPluginManager().registerEvents((Listener)new PotionListener(), (Plugin)this);
            }
        }
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            configFile.getParentFile().mkdirs();
            if (pre1_13) {
                this.getLogger().info("Generating 1.8-1.12 configuration file.");
                this.copy(this.getResource("config1_8.yml"), configFile);
            } else {
                this.getLogger().info("Generating 1.13+ configuration file.");
                this.copy(this.getResource("config1_13.yml"), configFile);
            }
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        config.options().copyHeader(true);
        ConfigUtil.init((FileConfiguration)config, configFile);
        if (!this.loadTypes()) {
            return;
        }
        holograms = Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays");
        if (holograms) {
            this.getLogger().info("HolographicDisplays has been detected detected.");
        }
        dbManager = new DatabaseManager();
        try {
            dbManager.setup(ConfigUtil.getString("Settings.Database.Type", "SQLite").equalsIgnoreCase("mysql"));
        }
        catch (Exception e) {
            this.getLogger().severe("There has been an error connecting to the database. The plugin will now be disabled.  Stack Trace:\n");
            e.printStackTrace();
        }
        Bukkit.getPluginManager().registerEvents((Listener)new SetupListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PressurePlateListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BreakListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FlyListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new FallListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DropListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new LeaveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MountListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SignListener(), (Plugin)this);
        this.getCommand("parkour").setExecutor((CommandExecutor)new CommandParkour());
        this.getCommand("parkour").setTabCompleter((TabCompleter)new ParkourTabComplete());
        for (Parkour parkour : CacheManager.getParkours()) {
            for (PressurePlate pp : parkour.getAllPoints()) {
                pp.placeMaterial();
                if (pp.getType() == 4) continue;
                if (pp.getType() != 2) {
                    CacheManager.addPoint(pp);
                    continue;
                }
                CacheManager.addRestartPoint(pp);
            }
            if (!HubParkour.isHolograms()) continue;
            this.getLogger().info("Generating holograms for parkour " + parkour.getName() + "...");
            parkour.generateHolograms();
            this.getLogger().info("Holograms successfully generated for parkour " + parkour.getName() + "!");
        }
        for (LeaderboardHologram hologram : CacheManager.getLeaderboards()) {
            if (!HubParkour.isHolograms()) continue;
            this.getLogger().info("Generating leaderboard hologram for parkour " + hologram.getParkour().getName() + " (ID: " + hologram.getId() + ") ...");
            hologram.generate();
            this.getLogger().info("Leaderboard hologram for parkour " + hologram.getParkour().getName() + " (ID: " + hologram.getId() + ") successfully generated!");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            placeholders = true;
            this.getLogger().info("PlaceholderAPI detected, registering HubParkour placeholder expansion.");
            new HubParkourExpansion(this).register();
        }
        if (!this.loadItems()) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Plugin successfully enabled!");
        if (ConfigUtil.getBoolean("Settings.Version-Checker.Enabled", true)) {
            String version = HubParkour.newVersionCheck();
            if (version != null) {
                this.getLogger().info("HubParkour v" + version + " is out now! I highly recommend you download the new version!");
            } else {
                this.getLogger().info("Your HubParkour version is up to date!");
            }
        }
    }

    public void onDisable() {
        if (HubParkour.isHolograms()) {
            for (Parkour parkour : CacheManager.getParkours()) {
                parkour.removeHolograms();
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!CacheManager.isParkour(player)) continue;
            HubParkourPlayer pl = CacheManager.getPlayer(player);
            pl.removeItems();
            pl.setToPrevState();
        }
    }

    public static HubParkour getInstance() {
        return instance;
    }

    public DatabaseManager getDbManager() {
        return dbManager;
    }

    private void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String c(boolean prefix, String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)((prefix ? ConfigUtil.getString("Messages.Prefix", "&2Parkour>> &r") : "&r") + message));
    }

    public static boolean isHolograms() {
        return holograms;
    }

    private boolean loadTypes() {
        Material end;
        String startMaterial = ConfigUtil.getString("Settings.Pressure-Plates.Start", HubParkour.isPre1_13() ? "WOOD_PLATE" : "OAK_PRESSURE_PLATE");
        String checkpointMaterial = ConfigUtil.getString("Settings.Pressure-Plates.Checkpoint", HubParkour.isPre1_13() ? "GOLD_PLATE" : "LIGHT_WEIGHTED_PRESSURE_PLATE");
        String endMaterial = ConfigUtil.getString("Settings.Pressure-Plates.End", HubParkour.isPre1_13() ? "IRON_PLATE" : "HEAVY_WEIGHTED_PRESSURE_PLATE");
        Material start = startMaterial.toLowerCase().contains("plate") ? Material.matchMaterial((String)startMaterial) : null;
        Material checkpoint = checkpointMaterial.toLowerCase().contains("plate") ? Material.matchMaterial((String)checkpointMaterial) : null;
        Material material = end = endMaterial.toLowerCase().contains("plate") ? Material.matchMaterial((String)endMaterial) : null;
        if (start == null || checkpoint == null || end == null) {
            this.getLogger().info("There are invalid values in your config.yml for the pressure plate types. Please correct the error and restart your server. The plugin will now be disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        CacheManager.setType(0, start);
        CacheManager.setType(1, end);
        CacheManager.setType(2, Material.AIR);
        CacheManager.setType(3, checkpoint);
        CacheManager.setType(4, Material.AIR);
        return true;
    }

    private boolean loadItems() {
        ItemStack item;
        Material reset = Material.matchMaterial((String)ConfigUtil.getString("Settings.Parkour-Items.Reset.Item", HubParkour.isPre1_13() ? "WOOD_DOOR" : "OAK_DOOR"));
        Material checkpoint = Material.matchMaterial((String)ConfigUtil.getString("Settings.Parkour-Items.Checkpoint.Item", HubParkour.isPre1_13() ? "GOLD_PLATE" : "LIGHT_WEIGHTED_PRESSURE_PLATE"));
        Material cancel = Material.matchMaterial((String)ConfigUtil.getString("Settings.Parkour-Items.Cancel.Item", HubParkour.isPre1_13() ? "BED" : "RED_BED"));
        Material hidden = Material.matchMaterial((String)ConfigUtil.getString("Settings.Parkour-Items.Hide.Hidden.Item", "MAGMA_CREAM"));
        Material shown = Material.matchMaterial((String)ConfigUtil.getString("Settings.Parkour-Items.Hide.Shown.Item", "SLIME_BALL"));
        if (reset == null || checkpoint == null || cancel == null || hidden == null || shown == null) {
            this.getLogger().info("There are invalid values in your config.yml for the parkour items. Please correct the error and restart your server. The plugin will now be disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        if (ConfigUtil.getInt("Settings.Parkour-Items.Cancel.Slot", 6) != -1) {
            item = ItemUtil.ci(cancel, ConfigUtil.getString("Settings.Parkour-Items.Cancel.Name", "&cCancel"), 1, "", (short)ConfigUtil.getInt("Settings.Parkour-Items.Cancel.Item-Data", 0));
            CacheManager.setItem(2, item);
        }
        if (ConfigUtil.getInt("Settings.Parkour-Items.Reset.Slot", 5) != -1) {
            item = ItemUtil.ci(reset, ConfigUtil.getString("Settings.Parkour-Items.Reset.Name", "&cReset"), 1, "", (short)ConfigUtil.getInt("Settings.Parkour-Items.Reset.Item-Data", 0));
            CacheManager.setItem(0, item);
        }
        if (ConfigUtil.getInt("Settings.Parkour-Items.Checkpoint.Slot", 4) != -1) {
            item = ItemUtil.ci(checkpoint, ConfigUtil.getString("Settings.Parkour-Items.Checkpoint.Name", "&aTeleport to Last Checkpoint"), 1, "", (short)ConfigUtil.getInt("Settings.Parkour-Items.Checkpoint.Item-Data", 0));
            CacheManager.setItem(1, item);
        }
        if (ConfigUtil.getInt("Settings.Parkour-Items.Hide.Slot", 8) != -1) {
            item = ItemUtil.ci(hidden, ConfigUtil.getString("Settings.Parkour-Items.Hide.Hidden.Name", "&cShow all players"), 1, "", (short)ConfigUtil.getInt("Settings.Parkour-Items.Hide.Hidden.Item-Data", 0));
            CacheManager.setItem(4, item);
            item = ItemUtil.ci(shown, ConfigUtil.getString("Settings.Parkour-Items.Hide.Shown.Name", "&aHide all players"), 1, "", (short)ConfigUtil.getInt("Settings.Parkour-Items.Hide.Shown.Item-Data", 0));
            CacheManager.setItem(3, item);
        }
        return true;
    }

    public static String newVersionCheck() {
        try {
            String oldVersion = HubParkour.getInstance().getDescription().getVersion();
            String newVersion = HubParkour.fetchSpigotVersion();
            if (newVersion != null && !newVersion.equals(oldVersion)) {
                return newVersion;
            }
            return null;
        }
        catch (Exception e) {
            HubParkour.getInstance().getLogger().info("Unable to check for new versions.");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchSpigotVersion() {
        String resourceId = "47713";
        try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId).openStream();
             Scanner scanner = new Scanner(inputStream);){
            if (!scanner.hasNext()) return null;
            String string = scanner.next();
            return string;
        }
        catch (IOException e) {
            HubParkour.getInstance().getLogger().info("Unable to connect to the Spigot resource API.");
            return null;
        }
    }

    public static boolean isPre1_13() {
        return pre1_13;
    }

    public static boolean isPost1_8() {
        return post1_8;
    }

    public static boolean isPost1_9() {
        return post1_9;
    }

    public static boolean isPlaceholders() {
        return placeholders;
    }

    static {
        placeholders = false;
        pre1_13 = false;
        post1_8 = true;
        post1_9 = false;
    }
}

