/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.api.items;

import me.block2block.hubparkour.api.HubParkourAPI;
import me.block2block.hubparkour.api.IHubParkourPlayer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class ParkourItem {
    protected final IHubParkourPlayer player;
    protected ItemStack originalItem;
    protected final int slot;
    protected final ItemStack item;

    public ParkourItem(IHubParkourPlayer player, int slot) {
        this.player = player;
        this.slot = slot;
        this.item = HubParkourAPI.getItem(this.getType());
    }

    public abstract int getType();

    public ItemStack getItem() {
        return this.item;
    }

    public void giveItem() {
        if (this.slot >= 0 && this.slot < 9) {
            this.originalItem = this.player.getPlayer().getInventory().getItem(this.slot);
            if (this.originalItem == null) {
                this.originalItem = new ItemStack(Material.AIR);
            }
            this.player.getPlayer().getInventory().setItem(this.slot, this.item);
        }
    }

    public void removeItem() {
        if (this.slot >= 0 && this.slot < 9 && this.originalItem != null) {
            this.player.getPlayer().getInventory().setItem(this.slot, this.originalItem);
            this.originalItem = null;
        } else if (this.slot >= 0 && this.slot < 9) {
            this.player.getPlayer().getInventory().setItem(this.slot, new ItemStack(Material.AIR));
        }
    }

    public IHubParkourPlayer getPlayer() {
        return this.player;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getOriginalItem() {
        return this.originalItem;
    }
}

