/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.api.plates;

import me.block2block.hubparkour.api.HubParkourAPI;
import me.block2block.hubparkour.api.IParkour;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;

public abstract class PressurePlate {
    protected final Location location;
    protected IParkour parkour;
    protected Material material;

    public PressurePlate(Location location) {
        this.location = location;
        this.material = HubParkourAPI.getPressurePlateType(this.getType());
    }

    public void setParkour(IParkour parkour) {
        this.parkour = parkour;
    }

    public Location getLocation() {
        return this.location;
    }

    public abstract int getType();

    public Material getMaterial() {
        return this.material;
    }

    public void placeMaterial() {
        if (this.material != Material.AIR) {
            if (this.location == null) {
                Bukkit.getLogger().warning("A location that one of your parkour points is in does not exist. Please delete the " + this.parkour.getName() + " parkour and set it up again.");
                return;
            }
            if (this.location.getWorld() == null) {
                Bukkit.getLogger().warning("A location that one of your parkour points is in does not exist. Please delete the " + this.parkour.getName() + " parkour and set it up again.");
                return;
            }
            this.location.getBlock().setType(this.material);
        }
    }

    public void removeMaterial() {
        this.location.getBlock().setType(Material.AIR);
    }

    public IParkour getParkour() {
        return this.parkour;
    }
}

