/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.plates.BorderPoint;
import me.block2block.hubparkour.api.plates.Checkpoint;
import me.block2block.hubparkour.api.plates.EndPoint;
import me.block2block.hubparkour.api.plates.RestartPoint;
import me.block2block.hubparkour.api.plates.StartPoint;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import me.block2block.hubparkour.utils.ItemUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang3.Range;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EditWizard {
    private final Player player;
    private final Parkour parkour;
    private int currentModification;
    private int after;
    private BorderPoint point;

    public EditWizard(Player player, Parkour parkour) {
        this.player = player;
        this.parkour = parkour;
        player.getInventory().addItem(new ItemStack[]{ItemUtil.ci(Material.STICK, "&2&lHubParkour Setup Stick", 1, "&rUse this item to;&rsetup your HubParkour;&rParkour.")});
        ConfigUtil.sendMessageOrDefault(player, "Messages.Commands.Admin.Edit.Entered-Edit-Mode", "You have entered edit mode. You have been given the setup stick.", true, Collections.emptyMap());
        this.returnToMainMenu();
    }

    public boolean onChat(String message) {
        switch (this.currentModification) {
            case -1: {
                int edit;
                try {
                    edit = Integer.parseInt(message);
                }
                catch (NumberFormatException exception) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Not-Valid-Edit", "That is not a valid edit. Please type the digit in chat.", true, Collections.emptyMap());
                    return true;
                }
                switch (edit) {
                    case 1: {
                        this.currentModification = 1;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Enter-New-Name", "Please enter a new name for your parkour into chat or type it with /parkour input [name]. It must not be a duplicate. Names are compatible with formatting codes.", true, Collections.emptyMap());
                        return true;
                    }
                    case 2: {
                        this.currentModification = 2;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Enter-New-End-Command", "Please enter a new end command for your parkour into chat or type it with /parkour input [name]. If you don't want one, just type 'none'.", true, Collections.emptyMap());
                        return true;
                    }
                    case 3: {
                        this.currentModification = 3;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Enter-New-Checkpoint-Command", "Please enter a new checkpoint command for your parkour into chat or type it with /parkour input [name]. If you don't want one, just type 'none'.", true, Collections.emptyMap());
                        return true;
                    }
                    case 4: {
                        this.currentModification = 4;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Select-New-Start-Point", "Please use the setup stick and select a new end point. This will take the location of where you are standing, and does take into account where you are looking.", true, Collections.emptyMap());
                        return true;
                    }
                    case 5: {
                        this.currentModification = 5;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Select-New-End-Point", "Please use the setup stick and select a new end point. This will take the location of where you are standing, and does take into account where you are looking.", true, Collections.emptyMap());
                        return true;
                    }
                    case 6: {
                        this.currentModification = 6;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Select-New-Restart-Point", "Please use the setup stick and select a new restart point. This will take the location of where you are standing, and does take into account where you are looking.", true, Collections.emptyMap());
                        return true;
                    }
                    case 7: {
                        this.returnToCheckpointMenu();
                        return true;
                    }
                    case 8: {
                        this.currentModification = 11;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Select-First-Border-Point", "Please use the setup stick and select your first new border point. This will take the location of where you are standing, and does not take into account where you are looking. If you do not wish to use border points, then enter 'done' or execute /parkour done.", true, Collections.emptyMap());
                        return true;
                    }
                    case 9: {
                        this.currentModification = 13;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Please-Set-Reward-Cooldown", "Please specify a new cooldown for you rewards (only applicable when you have repeat-rewards enabled). If you do not wish to have one, please type 'none'.", true, Collections.emptyMap());
                        return true;
                    }
                    case 10: {
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Exited-Edit-Mode", "You have left edit mode.", true, Collections.emptyMap());
                        CacheManager.leaveEditMode();
                        return true;
                    }
                }
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-End-Command", "You have entered edit mode. You have been given the setup stick.", true, Collections.emptyMap());
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Not-Valid-Edit", "That is not a valid edit. Please type the digit in chat.", true, Collections.emptyMap());
                return true;
            }
            case 1: {
                if (CacheManager.getParkour(message) == null || CacheManager.getParkour(message) == this.parkour) {
                    this.parkour.setName(message);
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Name-Set", "Your new name has been set!", true, Collections.emptyMap());
                    this.returnToMainMenu();
                } else {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Name-Taken", "That name is already taken! Try again!", true, Collections.emptyMap());
                }
                return true;
            }
            case 2: {
                String command = message;
                if (message.equalsIgnoreCase("none")) {
                    command = null;
                }
                this.parkour.setEndCommand(command);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.End-Command-Set", "Your new end command has been set!", true, Collections.emptyMap());
                this.returnToMainMenu();
                return true;
            }
            case 3: {
                String command = message;
                if (message.equalsIgnoreCase("none")) {
                    command = null;
                }
                this.parkour.setCheckpointCommand(command);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Command-Set", "Your new checkpoint command has been set!", true, Collections.emptyMap());
                this.returnToMainMenu();
                return true;
            }
            case 7: {
                int edit;
                try {
                    edit = Integer.parseInt(message);
                }
                catch (NumberFormatException exception) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Not-Valid-Edit", "That is not a valid edit. Please type the digit in chat.", true, Collections.emptyMap());
                    return true;
                }
                switch (edit) {
                    case 1: {
                        if (this.parkour.getCheckpoints().size() == 0) {
                            ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Delete.No-Checkpoints", "There are currently no checkpoints to delete! Try adding one instead!", true, Collections.emptyMap());
                            return true;
                        }
                        this.currentModification = 8;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Delete.Please-Enter-Checkpoint", "Which checkpoint number would you like to delete? Type the checkpoint number in chat.", true, Collections.emptyMap());
                        return true;
                    }
                    case 2: {
                        this.currentModification = 9;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Add.After-Which", "What checkpoint should this checkpoint come &a&lafter&r? Type the checkpoint number in chat. If you want this to become the first checkpoint, just type 0.", true, Collections.emptyMap());
                        return true;
                    }
                    case 3: {
                        this.returnToMainMenu();
                        return true;
                    }
                }
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Not-Valid-Edit", "That is not a valid edit. Please type the digit in chat.", true, Collections.emptyMap());
                return true;
            }
            case 8: {
                int checkpointNo;
                if (message.equalsIgnoreCase("cancel")) {
                    this.returnToCheckpointMenu();
                    return true;
                }
                try {
                    checkpointNo = Integer.parseInt(message);
                }
                catch (NumberFormatException exception) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Delete.Not-Valid-Checkpoint", "That is not a valid checkpoint, please try again. If you would like to cancel, type 'cancel'.", true, Collections.emptyMap());
                    return true;
                }
                Checkpoint checkpoint = this.parkour.getCheckpoint(checkpointNo);
                if (checkpoint == null) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Delete.Not-Valid-Checkpoint", "That checkpoint is not valid. If you want this to become the first checkpoint, just type 0.", true, Collections.emptyMap());
                    return true;
                }
                this.parkour.deleteCheckpoint(checkpoint);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Delete.Success", "Checkpoint successfully deleted!", true, Collections.emptyMap());
                this.returnToCheckpointMenu();
                return true;
            }
            case 9: {
                int checkpointNo;
                if (message.equalsIgnoreCase("cancel")) {
                    this.returnToCheckpointMenu();
                    return true;
                }
                try {
                    checkpointNo = Integer.parseInt(message);
                }
                catch (NumberFormatException exception) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Add.Not-Valid", "That checkpoint is not valid. If you want this to become the first checkpoint, just type 0.", true, Collections.emptyMap());
                    return true;
                }
                if (checkpointNo >= 0 && checkpointNo <= this.parkour.getNoCheckpoints()) {
                    this.after = checkpointNo;
                    this.currentModification = 10;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Add.Select-Checkpoint", "Please use the setup stick and select a new checkpoint to add. This will take the location of where you are standing, and does take into account where you are looking.", true, Collections.emptyMap());
                } else {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Add.Not-Valid", "The checkpoint has been successfully added!", true, Collections.emptyMap());
                }
                return true;
            }
            case 11: {
                if (message.equalsIgnoreCase("done")) {
                    this.parkour.setBorders(Collections.emptyList());
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Border-Updated", "Border successfully updated!", true, Collections.emptyMap());
                    this.returnToMainMenu();
                }
            }
            case 13: {
                int cooldown;
                String cooldowns = message;
                if (message.equalsIgnoreCase("none")) {
                    cooldowns = "-1";
                }
                try {
                    cooldown = Integer.parseInt(cooldowns);
                }
                catch (NumberFormatException e) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Invalid-Cooldown", "That cooldown is not valid. Please try again. If you do not wish to have one, please type 'none'.", true, Collections.emptyMap());
                    return true;
                }
                this.parkour.setRewardCooldown(cooldown);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Reward-Cooldown-Updated", "Reward cooldown successfully updated!", true, Collections.emptyMap());
                this.returnToMainMenu();
                return true;
            }
        }
        return false;
    }

    public void onStick(Location location) {
        switch (this.currentModification) {
            case 4: {
                StartPoint startPoint = new StartPoint(location);
                this.parkour.setStartPoint(startPoint);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Start-Point-Set", "Your new start point has been set!", true, Collections.emptyMap());
                this.returnToMainMenu();
                break;
            }
            case 5: {
                EndPoint endPoint = new EndPoint(location);
                this.parkour.setEndPoint(endPoint);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.End-Point-Set", "Your new end point has been set!", true, Collections.emptyMap());
                this.returnToMainMenu();
                break;
            }
            case 6: {
                RestartPoint restartPoint = new RestartPoint(location);
                this.parkour.setRestartPoint(restartPoint);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Restart-Point-Set", "Your new restart point has been set!", true, Collections.emptyMap());
                this.returnToMainMenu();
                break;
            }
            case 10: {
                Checkpoint checkpoint = new Checkpoint(location, this.after + 1);
                this.parkour.addCheckpoint(checkpoint, this.after + 1);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Checkpoint-Add.Success", "The checkpoint has been successfully added!", true, Collections.emptyMap());
                this.returnToCheckpointMenu();
                break;
            }
            case 11: {
                this.point = new BorderPoint(location);
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Select-Second-Border-Point", "Please use the setup stick and select your second new border point.", true, Collections.emptyMap());
                this.currentModification = 12;
                break;
            }
            case 12: {
                Range<Double> rangeX = Range.between(location.getX(), this.point.getLocation().getX());
                Range<Double> rangeY = Range.between(location.getY(), this.point.getLocation().getY());
                Range<Double> rangeZ = Range.between(location.getZ(), this.point.getLocation().getZ());
                if (!(rangeX.contains(this.parkour.getRestartPoint().getLocation().getX()) && rangeY.contains(this.parkour.getRestartPoint().getLocation().getY()) && rangeZ.contains(this.parkour.getRestartPoint().getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentModification = 11;
                    return;
                }
                if (!(rangeX.contains(this.parkour.getStart().getLocation().getX()) && rangeY.contains(this.parkour.getStart().getLocation().getY()) && rangeZ.contains(this.parkour.getStart().getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentModification = 11;
                    return;
                }
                if (!(rangeX.contains(this.parkour.getEndPoint().getLocation().getX()) && rangeY.contains(this.parkour.getEndPoint().getLocation().getY()) && rangeZ.contains(this.parkour.getEndPoint().getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentModification = 11;
                    return;
                }
                for (Checkpoint checkpoint : this.parkour.getCheckpoints()) {
                    if (rangeX.contains(checkpoint.getLocation().getX()) && rangeY.contains(checkpoint.getLocation().getY()) && rangeZ.contains(checkpoint.getLocation().getZ())) continue;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentModification = 11;
                    return;
                }
                this.parkour.setBorders(Arrays.asList(this.point, new BorderPoint(location)));
                this.point = null;
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Edit.Border-Updated", "Border successfully updated!", true, Collections.emptyMap());
                this.returnToMainMenu();
            }
        }
    }

    private void returnToMainMenu() {
        this.currentModification = -1;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("Please select what you would like to edit about parkour &a{parkour-name}&r. Type the digit into chat or type it with /parkour input [name].");
        defaultList.add("Please note that split times will be reset for this parkour upon modifications to any parkour points.");
        defaultList.add("&a1&r - Name");
        defaultList.add("&a2&r - End Command");
        defaultList.add("&a3&r - Checkpoint Command");
        defaultList.add("&a4&r - Start Point");
        defaultList.add("&a5&r - End Point");
        defaultList.add("&a6&r - Restart Point");
        defaultList.add("&a7&r - Checkpoints");
        defaultList.add("&a8&r - Border Points");
        defaultList.add("&a9&r - Reward Cooldown");
        defaultList.add("&a10&r - Exit Edit Mode");
        for (String s : ConfigUtil.getStringList("Messages.Commands.Admin.Edit.Choose-Edit", defaultList)) {
            sb.append(s.replace("{parkour-name}", this.parkour.getName())).append("\n");
        }
        String s = sb.toString();
        if (HubParkour.isPlaceholders()) {
            s = PlaceholderAPI.setPlaceholders((Player)this.player, (String)s);
        }
        this.player.sendMessage(HubParkour.c(true, s.trim()));
    }

    private void returnToCheckpointMenu() {
        this.currentModification = 7;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("What would you like to edit about checkpoints on parkour &a{parkour-name}&r? Type the digit into chat or type it with /parkour input [name].");
        defaultList.add("&a1&r - Delete checkpoints");
        defaultList.add("&a2&r - Add Checkpoints");
        defaultList.add("&a3&r - Cancel");
        for (String s : ConfigUtil.getStringList("Messages.Commands.Admin.Edit.Choose-Checkpoint-Edit", defaultList)) {
            sb.append(s.replace("{parkour-name}", this.parkour.getName())).append("\n");
        }
        String s = sb.toString();
        if (HubParkour.isPlaceholders()) {
            s = PlaceholderAPI.setPlaceholders((Player)this.player, (String)s);
        }
        this.player.sendMessage(HubParkour.c(true, s.trim()));
    }

    public Player getPlayer() {
        return this.player;
    }

    public Parkour getParkour() {
        return this.parkour;
    }
}

