/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.entities;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.IHubParkourPlayer;
import me.block2block.hubparkour.api.ILeaderboardHologram;
import me.block2block.hubparkour.api.ParkourRun;
import me.block2block.hubparkour.api.events.player.ParkourPlayerFailEvent;
import me.block2block.hubparkour.api.events.player.ParkourPlayerFinishEvent;
import me.block2block.hubparkour.api.items.CancelItem;
import me.block2block.hubparkour.api.items.CheckpointItem;
import me.block2block.hubparkour.api.items.HideItem;
import me.block2block.hubparkour.api.items.ParkourItem;
import me.block2block.hubparkour.api.items.ResetItem;
import me.block2block.hubparkour.api.plates.Checkpoint;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import me.block2block.hubparkour.utils.TitleUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HubParkourPlayer
implements IHubParkourPlayer {
    private final Player player;
    private final Parkour parkour;
    private final List<Checkpoint> checkpoints = new ArrayList<Checkpoint>();
    private final List<ParkourItem> parkourItems = new ArrayList<ParkourItem>();
    private long currentSplit;
    private Map<Integer, Long> splitTimes;
    private int lastReached = 0;
    private long startTime;
    private long previous = -2L;
    private List<Checkpoint> previouslyReachedCheckpoints;
    private boolean lastRunCompleted;
    private ItemStack[] inventory;
    private ItemStack[] extraContents;
    private ItemStack[] armorContents;
    private ItemStack[] storageContents;
    private BukkitTask actionBarTask;
    private final GameMode prevGamemode;
    private final double prevHealth;
    private final int prevHunger;
    private final ParkourRun parkourRun;
    private boolean touchedGround;

    public HubParkourPlayer(final Player p, final Parkour parkour) {
        this.parkour = parkour;
        this.player = p;
        this.parkourRun = new ParkourRun(this);
        this.startTime = System.currentTimeMillis();
        this.touchedGround = true;
        this.currentSplit = this.startTime;
        this.prevGamemode = this.player.getGameMode();
        this.prevHealth = this.player.getHealth();
        this.prevHunger = this.player.getFoodLevel();
        if (ConfigUtil.getBoolean("Settings.Health.Heal-To-Full", true)) {
            this.player.setHealth(20.0);
        }
        if (ConfigUtil.getBoolean("Settings.Hunger.Saturate-To-Full", true)) {
            this.player.setFoodLevel(30);
        }
        if (ConfigUtil.getBoolean("Settings.Parkour-Gamemode.Enabled", true)) {
            GameMode mode = GameMode.valueOf((String)ConfigUtil.getString("Settings.Parkour-Gamemode.Gamemode", "ADVENTURE"));
            this.player.setGameMode(mode);
        }
        new BukkitRunnable(){

            public void run() {
                HubParkourPlayer.this.lastRunCompleted = HubParkour.getInstance().getDbManager().wasCompletedLastRun(p, parkour);
                if ((ConfigUtil.getBoolean("Settings.Repeat-Rewards", true) || ConfigUtil.getBoolean("Settings.Exploit-Prevention.Checkpoint-Rewards-Everytime", false)) && HubParkourPlayer.this.lastRunCompleted) {
                    HubParkourPlayer.this.previouslyReachedCheckpoints = new ArrayList();
                    HubParkour.getInstance().getDbManager().resetReachedCheckpoints(p, parkour);
                } else {
                    HubParkourPlayer.this.previouslyReachedCheckpoints = HubParkour.getInstance().getDbManager().getReachedCheckpoints(p, parkour);
                }
                HubParkourPlayer.this.previous = HubParkour.getInstance().getDbManager().getTime(p, parkour);
                HubParkourPlayer.this.splitTimes = HubParkour.getInstance().getDbManager().getSplitTimes(p, parkour);
                HubParkour.getInstance().getDbManager().resetLastRun(p, parkour);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        this.parkourItems.add(new ResetItem(this, ConfigUtil.getInt("Settings.Parkour-Items.Reset.Slot", 5)));
        this.parkourItems.add(new CheckpointItem(this, ConfigUtil.getInt("Settings.Parkour-Items.Checkpoint.Slot", 4)));
        this.parkourItems.add(new CancelItem(this, ConfigUtil.getInt("Settings.Parkour-Items.Cancel.Slot", 6)));
        this.parkourItems.add(new HideItem(this, ConfigUtil.getInt("Settings.Parkour-Items.Hide.Slot", 8)));
        if (ConfigUtil.getBoolean("Settings.Action-Bar.Enabled", true)) {
            this.actionBarTask = new BukkitRunnable(){

                public void run() {
                    String message = HubParkour.c(false, ConfigUtil.getString("Messages.Parkour.Action-Bar", "&a&lCurrent Time: &r{current-time} - &a&lParkour: &r{parkour-name}&r - &a&lCurrent Checkpoint: &r#{current-checkpoint}").replace("{current-time}", ConfigUtil.formatTime(System.currentTimeMillis() - HubParkourPlayer.this.startTime)).replace("{parkour-name}", parkour.getName()).replace("{current-checkpoint}", HubParkourPlayer.this.lastReached + "").replace("{current-splittime}", "" + (float)(System.currentTimeMillis() - HubParkourPlayer.this.currentSplit) / 1000.0f));
                    if (HubParkour.isPlaceholders()) {
                        message = PlaceholderAPI.setPlaceholders((Player)HubParkourPlayer.this.player, (String)message);
                    }
                    TitleUtil.sendActionBar(HubParkourPlayer.this.player, message, ChatColor.WHITE, false);
                }
            }.runTaskTimerAsynchronously((Plugin)HubParkour.getInstance(), 0L, (long)ConfigUtil.getInt("Settings.Action-Bar.Update-Interval", 2));
        }
    }

    @Override
    public void checkpoint(final Checkpoint checkpoint) {
        if (this.lastReached == checkpoint.getCheckpointNo()) {
            this.currentSplit = System.currentTimeMillis();
            return;
        }
        if (!this.checkpoints.contains(checkpoint)) {
            this.lastReached = checkpoint.getCheckpointNo();
            this.parkourRun.checkpointHit();
            final long ms = System.currentTimeMillis() - this.currentSplit;
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put("checkpoint", checkpoint.getCheckpointNo() + "");
            bindings.put("new-time", ConfigUtil.formatTime(ms));
            if (this.splitTimes.containsKey(checkpoint.getCheckpointNo())) {
                bindings.put("old-time", ConfigUtil.formatTime(this.splitTimes.get(checkpoint.getCheckpointNo())));
                if (this.splitTimes.get(checkpoint.getCheckpointNo()) > ms) {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.Checkpoints.Reached.Beat-Split-Time", "You have reached checkpoint &a#{checkpoint}&r in &a{new-time}s&r and beat your personal best of &a{old-time}s&r!", true, bindings);
                    new BukkitRunnable(){

                        public void run() {
                            HubParkour.getInstance().getDbManager().setSplitTime(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour, checkpoint.getCheckpointNo(), ms, true);
                        }
                    }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                    this.splitTimes.put(checkpoint.getCheckpointNo(), ms);
                } else {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.Checkpoints.Reached.Not-Beat-Split-Time", "You have reached checkpoint &a#{checkpoint}&r in &a{new-time}s&r (personal best: {old-time}s)!", true, bindings);
                }
            } else {
                ConfigUtil.sendMessage(this.player, "Messages.Parkour.Checkpoints.Reached.New-Split-Time", "You have reached checkpoint &a#{checkpoint}&r in &a{new-time}s&r!", true, bindings);
                new BukkitRunnable(){

                    public void run() {
                        HubParkour.getInstance().getDbManager().setSplitTime(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour, checkpoint.getCheckpointNo(), ms, false);
                    }
                }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                this.splitTimes.put(checkpoint.getCheckpointNo(), ms);
            }
            this.checkpoints.add(checkpoint);
            if (!this.previouslyReachedCheckpoints.contains(checkpoint)) {
                if (this.parkour.getCheckpointCommand() != null) {
                    final long timestamp = System.currentTimeMillis();
                    if (this.parkour.getRewardCooldown() != -1) {
                        new BukkitRunnable(){

                            public void run() {
                                long timestamp1 = HubParkour.getInstance().getDbManager().getTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), checkpoint.getCheckpointNo());
                                if (timestamp1 != -1L) {
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTimeInMillis(timestamp1);
                                    calendar.add(11, HubParkourPlayer.this.parkour.getRewardCooldown());
                                    if (calendar.getTimeInMillis() > timestamp) {
                                        return;
                                    }
                                }
                                new BukkitRunnable(){

                                    public void run() {
                                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)HubParkourPlayer.this.parkour.getCheckpointCommand().replace("{player-name}", HubParkourPlayer.this.player.getName()).replace("{player-uuid}", HubParkourPlayer.this.player.getUniqueId().toString()));
                                    }
                                }.runTask((Plugin)HubParkour.getInstance());
                                HubParkour.getInstance().getDbManager().updateTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), checkpoint.getCheckpointNo(), timestamp);
                            }
                        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                    } else {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.parkour.getCheckpointCommand().replace("{player-name}", this.player.getName()).replace("{player-uuid}", this.player.getUniqueId().toString()));
                    }
                }
            } else if (ConfigUtil.getBoolean("Settings.Exploit-Prevention.Checkpoint-Rewards-Everytime", false) && this.parkour.getCheckpointCommand() != null) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.parkour.getCheckpointCommand().replace("{player-name}", this.player.getName()).replace("{player-uuid}", this.player.getUniqueId().toString()));
            }
            this.previouslyReachedCheckpoints.add(checkpoint);
            new BukkitRunnable(){

                public void run() {
                    HubParkour.getInstance().getDbManager().reachedCheckpoint(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour, checkpoint);
                }
            }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        }
    }

    @Override
    public void end(ParkourPlayerFailEvent.FailCause cause) {
        if (cause != null) {
            ParkourPlayerFailEvent failEvent = new ParkourPlayerFailEvent(this.parkour, this, cause);
            Bukkit.getPluginManager().callEvent((Event)failEvent);
            if (failEvent.isCancelled()) {
                return;
            }
            if (this.actionBarTask != null) {
                this.actionBarTask.cancel();
                this.actionBarTask = null;
            }
            switch (cause) {
                case FLY: {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Fly", "You are not allowed to fly while doing the parkour. Parkour failed!", true, Collections.emptyMap());
                    break;
                }
                case ELYTRA_USE: {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Elytra-Use", "You are not allowed to use an Elytra while doing the parkour. Parkour failed!", true, Collections.emptyMap());
                    break;
                }
                case TELEPORTATION: {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Teleportation", "You are not allowed to teleport while doing the parkour. Parkour failed!", true, Collections.emptyMap());
                    break;
                }
                case NEW_PARKOUR: {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Parkour-Change", "You have started another parkour, parkour failed!", true, Collections.emptyMap());
                }
            }
            final HubParkourPlayer pl = this;
            final long time = System.currentTimeMillis() - this.startTime;
            new BukkitRunnable(){

                public void run() {
                    HubParkour.getInstance().getDbManager().addAttempt(pl, HubParkourPlayer.this.parkour, time);
                }
            }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        } else {
            long timestamp;
            if (ConfigUtil.getBoolean("Settings.Must-Complete-All-Checkpoints", true) && this.checkpoints.size() != this.parkour.getNoCheckpoints()) {
                ParkourPlayerFailEvent failEvent = new ParkourPlayerFailEvent(this.parkour, this, ParkourPlayerFailEvent.FailCause.NOT_ENOUGH_CHECKPOINTS);
                Bukkit.getPluginManager().callEvent((Event)failEvent);
                if (failEvent.isCancelled()) {
                    return;
                }
                if (this.actionBarTask != null) {
                    this.actionBarTask.cancel();
                    this.actionBarTask = null;
                }
                final HubParkourPlayer pl = this;
                final long time = System.currentTimeMillis() - this.startTime;
                new BukkitRunnable(){

                    public void run() {
                        HubParkour.getInstance().getDbManager().addAttempt(pl, HubParkourPlayer.this.parkour, time);
                    }
                }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Not-Enough-Checkpoints", "You did not reach enough checkpoints, parkour failed!", true, Collections.emptyMap());
                this.parkour.playerEnd(this);
                if (ConfigUtil.getBoolean("Settings.Health.Heal-To-Full", true)) {
                    double health = this.prevHealth;
                    if (health > this.player.getMaxHealth()) {
                        health = this.player.getMaxHealth();
                    }
                    this.player.setHealth(health);
                }
                if (ConfigUtil.getBoolean("Settings.Hunger.Saturate-To-Full", true)) {
                    this.player.setFoodLevel(this.prevHunger);
                }
                if (ConfigUtil.getBoolean("Settings.Parkour-Gamemode.Enabled", true)) {
                    this.player.setGameMode(this.prevGamemode);
                }
                CacheManager.playerEnd(this);
                this.removeItems();
                return;
            }
            final long finishMili = System.currentTimeMillis() - this.startTime;
            final long splitMs = System.currentTimeMillis() - this.currentSplit;
            ParkourPlayerFinishEvent finishEvent = new ParkourPlayerFinishEvent(this.parkour, this, finishMili, finishMili + this.startTime, this.startTime);
            Bukkit.getPluginManager().callEvent((Event)finishEvent);
            if (finishEvent.isCancelled()) {
                return;
            }
            if (this.actionBarTask != null) {
                this.actionBarTask.cancel();
                this.actionBarTask = null;
            }
            int check = 0;
            if (this.checkpoints.size() > 0) {
                check = this.checkpoints.get(this.checkpoints.size() - 1).getCheckpointNo() + 1;
            }
            final HubParkourPlayer pl = this;
            new BukkitRunnable(){

                public void run() {
                    HubParkour.getInstance().getDbManager().completedLastRun(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour);
                    HubParkour.getInstance().getDbManager().addCompletion(pl, HubParkourPlayer.this.parkour, finishMili);
                }
            }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
            final HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put("new-time", ConfigUtil.formatTime(splitMs));
            if (this.splitTimes.containsKey(check)) {
                long oldSplit = this.splitTimes.get(check);
                bindings.put("old-time", ConfigUtil.formatTime(oldSplit));
                if (oldSplit > splitMs) {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Split-Time.Beat-Split-Time", "You have reached the finish point in &a{new-time}s&r and beat your personal best of &a{old-time}s&r!", true, bindings);
                    final int finalCheck = check;
                    new BukkitRunnable(){

                        public void run() {
                            HubParkour.getInstance().getDbManager().setSplitTime(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour, finalCheck, splitMs, true);
                        }
                    }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                } else {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Split-Time.Not-Beat-Split-Time", "You have reached the finish point in &a{new-time}s&r (personal best: {old-time}s)!", true, bindings);
                }
            } else {
                ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Split-Time.New-Split-Time", "You have reached the finish point in &a{new-time}s&r!", true, bindings);
                final int finalCheck = check;
                new BukkitRunnable(){

                    public void run() {
                        HubParkour.getInstance().getDbManager().setSplitTime(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour, finalCheck, splitMs, false);
                    }
                }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
            }
            if (this.previous > 0L) {
                if (ConfigUtil.getBoolean("Settings.Repeat-Rewards", true) && this.parkour.getEndCommand() != null) {
                    timestamp = System.currentTimeMillis();
                    if (this.parkour.getRewardCooldown() != -1) {
                        new BukkitRunnable(){

                            public void run() {
                                long timestamp1 = HubParkour.getInstance().getDbManager().getTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), -1);
                                if (timestamp1 != -1L) {
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTimeInMillis(timestamp1);
                                    calendar.add(11, HubParkourPlayer.this.parkour.getRewardCooldown());
                                    if (calendar.getTimeInMillis() > timestamp) {
                                        return;
                                    }
                                }
                                new BukkitRunnable(){

                                    public void run() {
                                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)HubParkourPlayer.this.parkour.getEndCommand().replace("{player-name}", HubParkourPlayer.this.player.getName()).replace("{player-uuid}", HubParkourPlayer.this.player.getUniqueId().toString()));
                                    }
                                }.runTask((Plugin)HubParkour.getInstance());
                                HubParkour.getInstance().getDbManager().updateTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), -1, timestamp);
                            }
                        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                    } else {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.parkour.getEndCommand().replace("{player-name}", this.player.getName()).replace("{player-uuid}", this.player.getUniqueId().toString()));
                    }
                }
                bindings.clear();
                bindings.put("time", ConfigUtil.formatTime(finishMili));
                bindings.put("parkour-name", this.parkour.getName());
                if (finishMili < this.previous) {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Beat-Previous-Personal-Best", "You beat your previous record and you managed to complete the &a{parkour-name} &rparkour in &a{time} &rseconds!", true, bindings);
                    new BukkitRunnable(){

                        public void run() {
                            HubParkour.getInstance().getDbManager().newTime(HubParkourPlayer.this.player, finishMili, true, HubParkourPlayer.this.parkour);
                            int position = HubParkour.getInstance().getDbManager().leaderboardPosition(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour);
                            bindings.clear();
                            bindings.put("position", "" + position);
                            bindings.put("suffix", position % 10 == 1 ? "st" : (position % 10 == 2 ? "nd" : (position % 10 == 3 ? (position == 13 ? "th" : "rd") : "th")));
                            bindings.put("parkour-name", HubParkourPlayer.this.parkour.getName());
                            ConfigUtil.sendMessage(HubParkourPlayer.this.player, "Messages.Parkour.Leaderboard.Leaderboard-Place", "You are in &a{position}{suffix} place&r for the &a{parkour-name}&r parkour!", true, bindings);
                            for (final ILeaderboardHologram hologram : HubParkourPlayer.this.parkour.getLeaderboards()) {
                                new BukkitRunnable(){

                                    public void run() {
                                        hologram.refresh();
                                    }
                                }.runTask((Plugin)HubParkour.getInstance());
                            }
                        }
                    }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                } else {
                    ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Not-Beat-Previous-Personal-Best", "You didn't beat your previous record, but you managed to complete the &a{parkour-name} &rparkour in &a{time} &rseconds!", true, bindings);
                    new BukkitRunnable(){

                        public void run() {
                            int position = HubParkour.getInstance().getDbManager().leaderboardPosition(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour);
                            bindings.clear();
                            bindings.put("position", "" + position);
                            bindings.put("suffix", position % 10 == 1 ? "st" : (position % 10 == 2 ? "nd" : (position % 10 == 3 ? (position == 13 ? "th" : "rd") : "th")));
                            bindings.put("parkour-name", HubParkourPlayer.this.parkour.getName());
                            ConfigUtil.sendMessage(HubParkourPlayer.this.player, "Messages.Parkour.Leaderboard.Leaderboard-Place", "You are in &a{position}{suffix} place&r for the &a{parkour-name}&r parkour!", true, bindings);
                        }
                    }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                }
            } else if (this.previous == -1L) {
                if (this.parkour.getEndCommand() != null) {
                    timestamp = System.currentTimeMillis();
                    if (this.parkour.getRewardCooldown() != -1) {
                        new BukkitRunnable(){

                            public void run() {
                                long timestamp1 = HubParkour.getInstance().getDbManager().getTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), -1);
                                if (timestamp1 != -1L) {
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTimeInMillis(timestamp1);
                                    calendar.add(11, HubParkourPlayer.this.parkour.getRewardCooldown());
                                    if (calendar.getTimeInMillis() > timestamp) {
                                        return;
                                    }
                                }
                                new BukkitRunnable(){

                                    public void run() {
                                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)HubParkourPlayer.this.parkour.getEndCommand().replace("{player-name}", HubParkourPlayer.this.player.getName()).replace("{player-uuid}", HubParkourPlayer.this.player.getUniqueId().toString()));
                                    }
                                }.runTask((Plugin)HubParkour.getInstance());
                                HubParkour.getInstance().getDbManager().updateTimestamp(HubParkourPlayer.this.player.getUniqueId(), HubParkourPlayer.this.parkour.getId(), -1, timestamp);
                            }
                        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                    } else {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.parkour.getEndCommand().replace("{player-name}", this.player.getName()).replace("{player-uuid}", this.player.getUniqueId().toString()));
                    }
                }
                bindings.clear();
                bindings.put("time", ConfigUtil.formatTime(finishMili));
                bindings.put("parkour-name", this.parkour.getName());
                ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.First-Time", "Well done! You completed the &a{parkour-name}&r parkour in &a{time}&r seconds! Your reward will be applied shortly!", true, bindings);
                new BukkitRunnable(){

                    public void run() {
                        HubParkour.getInstance().getDbManager().newTime(HubParkourPlayer.this.player, finishMili, false, HubParkourPlayer.this.parkour);
                        int position = HubParkour.getInstance().getDbManager().leaderboardPosition(HubParkourPlayer.this.player, HubParkourPlayer.this.parkour);
                        bindings.clear();
                        bindings.put("position", "" + position);
                        bindings.put("suffix", position % 10 == 1 ? "st" : (position % 10 == 2 ? "nd" : (position % 10 == 3 ? "rd" : "th")));
                        bindings.put("parkour-name", HubParkourPlayer.this.parkour.getName());
                        ConfigUtil.sendMessage(HubParkourPlayer.this.player, "Messages.Parkour.Leaderboard.Leaderboard-Place", "You are in &a{position}{suffix} place&r for the &a{parkour-name}&r parkour!", true, bindings);
                        for (final ILeaderboardHologram hologram : HubParkourPlayer.this.parkour.getLeaderboards()) {
                            new BukkitRunnable(){

                                public void run() {
                                    hologram.refresh();
                                }
                            }.runTask((Plugin)HubParkour.getInstance());
                        }
                    }
                }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
            } else {
                ConfigUtil.sendMessage(this.player, "Messages.Parkour.End.Failed.Too-Quick", "You completed the parkour too quickly, parkour failed!", true, Collections.emptyMap());
            }
        }
        this.removeItems();
        this.parkour.playerEnd(this);
        if (ConfigUtil.getBoolean("Settings.Health.Heal-To-Full", true)) {
            double health = this.prevHealth;
            if (health > this.player.getMaxHealth()) {
                health = this.player.getMaxHealth();
            }
            this.player.setHealth(health);
        }
        if (ConfigUtil.getBoolean("Settings.Hunger.Saturate-To-Full", true)) {
            this.player.setFoodLevel(this.prevHunger);
        }
        if (ConfigUtil.getBoolean("Settings.Parkour-Gamemode.Enabled", true)) {
            this.player.setGameMode(this.prevGamemode);
        }
        CacheManager.playerEnd(this);
    }

    @Override
    public int getLastReached() {
        return this.lastReached;
    }

    @Override
    public Parkour getParkour() {
        return this.parkour;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void restart() {
        this.startTime = System.currentTimeMillis();
        this.checkpoints.clear();
        this.lastReached = 0;
        this.currentSplit = this.startTime;
    }

    @Override
    public long getPrevious() {
        return this.previous;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public List<ParkourItem> getParkourItems() {
        return this.parkourItems;
    }

    @Override
    public void giveItems() {
        this.inventory = this.player.getInventory().getContents();
        this.armorContents = this.player.getInventory().getArmorContents();
        if (HubParkour.isPost1_8()) {
            this.extraContents = this.player.getInventory().getExtraContents();
            this.storageContents = this.player.getInventory().getStorageContents();
        }
        if (ConfigUtil.getBoolean("Settings.Parkour-Items.Clear-Inventory-On-Parkour-Start", true)) {
            this.player.getInventory().clear();
        }
        for (ParkourItem item : this.parkourItems) {
            item.giveItem();
        }
    }

    @Override
    public void removeItems() {
        for (ParkourItem item : this.parkourItems) {
            item.removeItem();
        }
        if (ConfigUtil.getBoolean("Settings.Parkour-Items.Clear-Inventory-On-Parkour-Start", true)) {
            if (this.inventory != null) {
                this.player.getInventory().setContents(this.inventory);
            }
            if (this.armorContents != null) {
                this.player.getInventory().setArmorContents(this.armorContents);
            }
            if (HubParkour.isPost1_8()) {
                if (this.extraContents != null) {
                    this.player.getInventory().setExtraContents(this.extraContents);
                }
                if (this.storageContents != null) {
                    this.player.getInventory().setStorageContents(this.storageContents);
                }
            }
        }
    }

    @Override
    public BukkitTask getActionBarTask() {
        return this.actionBarTask;
    }

    @Override
    public Map<Integer, Long> getSplitTimes() {
        return this.splitTimes;
    }

    @Override
    public long getCurrentSplit() {
        return this.currentSplit;
    }

    @Override
    public GameMode getPrevGamemode() {
        return this.prevGamemode;
    }

    public void setToPrevState() {
        if (ConfigUtil.getBoolean("Settings.Parkour-Gamemode.Enabled", true)) {
            this.player.setGameMode(this.prevGamemode);
        }
        if (ConfigUtil.getBoolean("Settings.Health.Heal-To-Full", true)) {
            double health = this.prevHealth;
            if (health > this.player.getMaxHealth()) {
                health = this.player.getMaxHealth();
            }
            this.player.setHealth(health);
        }
        if (ConfigUtil.getBoolean("Settings.Hunger.Saturate-To-Full", true)) {
            this.player.setFoodLevel(this.prevHunger);
        }
    }

    @Override
    public double getPrevHealth() {
        return this.prevHealth;
    }

    @Override
    public int getPrevHunger() {
        return this.prevHunger;
    }

    @Override
    public ParkourRun getParkourRun() {
        return this.parkourRun;
    }

    @Override
    public boolean hasTouchedGround() {
        return this.touchedGround;
    }

    @Override
    public void touchedGround() {
        this.touchedGround = true;
    }

    @Override
    public void leftGround() {
        this.touchedGround = false;
    }
}

