/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.entities;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.ILeaderboardHologram;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.utils.ConfigUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LeaderboardHologram
implements ILeaderboardHologram {
    private int id;
    private final Location location;
    private final Parkour parkour;
    private Hologram hologram;

    public LeaderboardHologram(Location location, Parkour parkour, int id) {
        this.location = location;
        this.parkour = parkour;
        this.id = id;
    }

    public LeaderboardHologram(Location location, Parkour parkour) {
        this.parkour = parkour;
        this.location = location;
        final LeaderboardHologram instance = this;
        new BukkitRunnable(){

            public void run() {
                LeaderboardHologram.this.id = HubParkour.getInstance().getDbManager().addHologram(instance);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    @Override
    public void generate() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
        if (this.location == null) {
            HubParkour.getInstance().getLogger().info("The location of one of your leaderboard holograms for parkour " + this.parkour.getName() + " no longer exists. Please delete leaderboard hologram " + this.id + ".");
            return;
        }
        if (this.location.getWorld() == null) {
            HubParkour.getInstance().getLogger().info("The location of one of your leaderboard holograms for parkour " + this.parkour.getName() + " no longer exists. Please delete leaderboard hologram " + this.id + ".");
            return;
        }
        this.hologram = HologramsAPI.createHologram((Plugin)HubParkour.getInstance(), (Location)this.location);
        this.hologram.appendTextLine(ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigUtil.getString("Messages.Holograms.Leaderboard.Header", "&9&lLeaderboard for {parkour-name}").replace("{parkour-name}", this.parkour.getName())));
        this.refresh();
    }

    @Override
    public void remove() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
    }

    @Override
    public void refresh() {
        for (int i = this.hologram.size() - 1; i > 0; --i) {
            this.hologram.removeLine(i);
        }
        final HashMap<Integer, List<String>> leaderboard = HubParkour.getInstance().getDbManager().getLeaderboard(this.parkour, ConfigUtil.getInt("Settings.Leaderboard.Limit", 10));
        new BukkitRunnable(){

            public void run() {
                Iterator iterator = leaderboard.keySet().iterator();
                while (iterator.hasNext()) {
                    int place = (Integer)iterator.next();
                    List record = (List)leaderboard.get(place);
                    LeaderboardHologram.this.hologram.appendTextLine(ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigUtil.getString("Messages.Holograms.Leaderboard.Line", "&3#{place}&r - &b{player-name}&r - &b{player-time}").replace("{player-name}", (CharSequence)record.get(0)).replace("{player-time}", ConfigUtil.formatTime(Long.parseLong((String)record.get(1)))).replace("{place}", "" + place)));
                }
            }
        }.runTask((Plugin)HubParkour.getInstance());
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public Parkour getParkour() {
        return this.parkour;
    }

    @Override
    public int getId() {
        return this.id;
    }
}

