/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.entities;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.IHubParkourPlayer;
import me.block2block.hubparkour.api.ILeaderboardHologram;
import me.block2block.hubparkour.api.IParkour;
import me.block2block.hubparkour.api.plates.BorderPoint;
import me.block2block.hubparkour.api.plates.Checkpoint;
import me.block2block.hubparkour.api.plates.EndPoint;
import me.block2block.hubparkour.api.plates.PressurePlate;
import me.block2block.hubparkour.api.plates.RestartPoint;
import me.block2block.hubparkour.api.plates.StartPoint;
import me.block2block.hubparkour.api.signs.ClickableSign;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Parkour
implements IParkour {
    private final int id;
    private String name;
    private StartPoint start;
    private EndPoint endPoint;
    private final List<Checkpoint> checkpoints;
    private final List<IHubParkourPlayer> players;
    private String checkpointCommand;
    private String endCommand;
    private RestartPoint restartPoint;
    private int rewardCooldown;
    private final Map<PressurePlate, Hologram> holograms = new HashMap<PressurePlate, Hologram>();
    private final List<ILeaderboardHologram> leaderboardHolograms = new ArrayList<ILeaderboardHologram>();
    private final List<BorderPoint> borderPoints;

    public Parkour(int id, String name, StartPoint start, EndPoint end, List<Checkpoint> checkpoints, RestartPoint restartPoint, List<BorderPoint> borderPoints, String checkpointCommand, String endCommand, int rewardCooldown) {
        this.id = id;
        this.start = start;
        this.start.setParkour(this);
        this.endPoint = end;
        this.endPoint.setParkour(this);
        this.checkpoints = checkpoints;
        for (Checkpoint checkpoint : checkpoints) {
            checkpoint.setParkour(this);
        }
        this.players = new ArrayList<IHubParkourPlayer>();
        this.checkpointCommand = checkpointCommand;
        this.endCommand = endCommand;
        this.name = name;
        this.restartPoint = restartPoint;
        this.borderPoints = borderPoints;
        for (BorderPoint borderPoint : borderPoints) {
            borderPoint.setParkour(this);
        }
    }

    public Parkour(Parkour parkour, int id) {
        this.id = id;
        this.start = parkour.getStart();
        this.start.setParkour(this);
        this.endPoint = parkour.getEndPoint();
        this.endPoint.setParkour(this);
        this.checkpoints = parkour.getCheckpoints();
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpoint.setParkour(this);
        }
        this.players = new ArrayList<IHubParkourPlayer>();
        this.checkpointCommand = parkour.getCheckpointCommand();
        this.endCommand = parkour.getEndCommand();
        this.name = parkour.getName();
        this.restartPoint = parkour.getRestartPoint();
        this.borderPoints = parkour.getBorders();
        this.rewardCooldown = parkour.getRewardCooldown();
    }

    @Override
    public int getNoCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public List<Checkpoint> getCheckpoints() {
        return new ArrayList<Checkpoint>(this.checkpoints);
    }

    @Override
    public List<IHubParkourPlayer> getPlayers() {
        return new ArrayList<IHubParkourPlayer>(this.players);
    }

    @Override
    public RestartPoint getRestartPoint() {
        return this.restartPoint;
    }

    @Override
    public StartPoint getStart() {
        return this.start;
    }

    @Override
    public String getCheckpointCommand() {
        return this.checkpointCommand;
    }

    @Override
    public String getEndCommand() {
        return this.endCommand;
    }

    @Override
    public List<PressurePlate> getAllPoints() {
        ArrayList<PressurePlate> pressurePlates = new ArrayList<PressurePlate>(this.checkpoints);
        pressurePlates.add((Checkpoint)((Object)this.endPoint));
        pressurePlates.add((Checkpoint)((Object)this.start));
        pressurePlates.add((Checkpoint)((Object)this.restartPoint));
        pressurePlates.addAll(this.borderPoints);
        return pressurePlates;
    }

    @Override
    public void generateHolograms() {
        block6: for (PressurePlate p : this.getAllPoints()) {
            ArrayList<String> defaultValues = new ArrayList<String>();
            String configKey = "";
            switch (p.getType()) {
                case 0: {
                    if (!ConfigUtil.getBoolean("Settings.Holograms.Start", true)) continue block6;
                    configKey = "Start";
                    defaultValues.add("&9&l&n{parkour-name}");
                    defaultValues.add("&9&lParkour Start");
                    break;
                }
                case 1: {
                    if (!ConfigUtil.getBoolean("Settings.Holograms.End", true)) continue block6;
                    configKey = "End";
                    defaultValues.add("&9&l&n{parkour-name}");
                    defaultValues.add("&9&lParkour End");
                    break;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    if (!ConfigUtil.getBoolean("Settings.Holograms.Checkpoint", true)) continue block6;
                    configKey = "Checkpoint";
                    defaultValues.add("&9&l&n{parkour-name}");
                    defaultValues.add("&9&lCheckpoint #{checkpoint}");
                    break;
                }
            }
            Location l = p.getLocation().clone();
            l.setX(l.getX() + 0.5);
            l.setZ(l.getZ() + 0.5);
            l.setY(l.getY() + 2.0);
            if (l.getWorld() == null) continue;
            Hologram hologram = HologramsAPI.createHologram((Plugin)HubParkour.getInstance(), (Location)l);
            int counter = 0;
            for (String s : ConfigUtil.getStringList("Messages.Holograms." + configKey, defaultValues)) {
                s = ChatColor.translateAlternateColorCodes((char)'&', (String)s.replace("{parkour-name}", this.name).replace("{checkpoint}", p instanceof Checkpoint ? ((Checkpoint)p).getCheckpointNo() + "" : ""));
                if (HubParkour.isPlaceholders()) {
                    s = PlaceholderAPI.setPlaceholders(null, (String)s);
                }
                TextLine textLine = hologram.appendTextLine(s);
                ++counter;
            }
            this.holograms.put(p, hologram);
        }
    }

    @Override
    public void removeHolograms() {
        for (Hologram h : this.holograms.values()) {
            h.delete();
        }
    }

    @Override
    public void playerStart(IHubParkourPlayer p) {
        this.players.add(p);
        for (ClickableSign sign : CacheManager.getSigns().values()) {
            if (!sign.getParkour().equals(this)) continue;
            sign.refresh();
        }
    }

    @Override
    public void playerEnd(IHubParkourPlayer p) {
        this.players.remove(p);
        for (ClickableSign sign : CacheManager.getSigns().values()) {
            if (!sign.getParkour().equals(this)) continue;
            sign.refresh();
        }
    }

    @Override
    public Checkpoint getCheckpoint(int checkpointNo) {
        for (Checkpoint cp : this.checkpoints) {
            if (cp.getCheckpointNo() != checkpointNo) continue;
            return cp;
        }
        return null;
    }

    @Override
    public void addHologram(ILeaderboardHologram hologram) {
        this.leaderboardHolograms.add(hologram);
    }

    @Override
    public void removeHologram(ILeaderboardHologram hologram) {
        this.leaderboardHolograms.remove(hologram);
    }

    @Override
    public List<ILeaderboardHologram> getLeaderboards() {
        return this.leaderboardHolograms;
    }

    @Override
    public void setName(final String name) {
        this.name = name;
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setName(Parkour.this.id, name);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        new BukkitRunnable(){

            public void run() {
                if (HubParkour.isHolograms()) {
                    Parkour.this.removeHolograms();
                    Parkour.this.generateHolograms();
                    for (ILeaderboardHologram hologram : Parkour.this.leaderboardHolograms) {
                        hologram.remove();
                        hologram.generate();
                    }
                }
            }
        }.runTask((Plugin)HubParkour.getInstance());
    }

    @Override
    public void setEndCommand(final String endCommand) {
        this.endCommand = endCommand;
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setEndCommand(Parkour.this.id, endCommand);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    @Override
    public void setCheckpointCommand(final String checkpointCommand) {
        this.checkpointCommand = checkpointCommand;
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setCheckpointCommand(Parkour.this.id, checkpointCommand);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    @Override
    public void setStartPoint(final StartPoint point) {
        CacheManager.removePlate(this.start);
        this.start = point;
        CacheManager.addPoint(point);
        this.start.setParkour(this);
        point.placeMaterial();
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setStartPoint(Parkour.this.id, point);
                HubParkour.getInstance().getDbManager().resetSplitTimes(Parkour.this.id);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        if (HubParkour.isHolograms()) {
            this.removeHolograms();
            this.generateHolograms();
        }
    }

    @Override
    public void setEndPoint(final EndPoint point) {
        CacheManager.removePlate(this.endPoint);
        this.endPoint = point;
        CacheManager.addPoint(point);
        this.endPoint.setParkour(this);
        point.placeMaterial();
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setEndPoint(Parkour.this.id, point);
                HubParkour.getInstance().getDbManager().resetSplitTimes(Parkour.this.id);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        if (HubParkour.isHolograms()) {
            this.removeHolograms();
            this.generateHolograms();
        }
    }

    @Override
    public void setRestartPoint(final RestartPoint point) {
        CacheManager.removeRestartPoint(this.restartPoint);
        this.restartPoint = point;
        this.restartPoint.setParkour(this);
        CacheManager.addRestartPoint(point);
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setRestartPoint(Parkour.this.id, point);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    @Override
    public void addCheckpoint(final Checkpoint point, int checkNo) {
        point.setParkour(this);
        CacheManager.addPoint(point);
        ArrayList<Checkpoint> checkpoints = new ArrayList<Checkpoint>(this.checkpoints);
        this.checkpoints.clear();
        for (final Checkpoint checkpoint : checkpoints) {
            if (checkpoint.getCheckpointNo() >= checkNo) {
                if (checkpoint.getCheckpointNo() == checkNo) {
                    this.checkpoints.add(point);
                }
                checkpoint.setCheckpointNo(checkpoint.getCheckpointNo() + 1);
                new BukkitRunnable(){

                    public void run() {
                        HubParkour.getInstance().getDbManager().updateCheckpointNumber(Parkour.this.id, checkpoint);
                    }
                }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
            }
            this.checkpoints.add(checkpoint);
        }
        if (!this.checkpoints.contains(point)) {
            this.checkpoints.add(point);
        }
        point.placeMaterial();
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().addCheckpoint(Parkour.this.id, point);
                HubParkour.getInstance().getDbManager().resetSplitTimes(Parkour.this.id);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        if (HubParkour.isHolograms()) {
            this.removeHolograms();
            this.generateHolograms();
        }
    }

    @Override
    public void deleteCheckpoint(final Checkpoint point) {
        new BukkitRunnable(){

            public void run() {
                CacheManager.removePlate(point);
            }
        }.runTask((Plugin)HubParkour.getInstance());
        this.checkpoints.remove(point);
        for (final Checkpoint checkpoint : this.checkpoints) {
            if (checkpoint.getCheckpointNo() <= point.getCheckpointNo()) continue;
            checkpoint.setCheckpointNo(checkpoint.getCheckpointNo() - 1);
            new BukkitRunnable(){

                public void run() {
                    HubParkour.getInstance().getDbManager().updateCheckpointNumber(Parkour.this.id, checkpoint);
                }
            }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
        }
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().deleteCheckpoint(Parkour.this.id, point);
                HubParkour.getInstance().getDbManager().resetSplitTimes(Parkour.this.id);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    public void setBorders(final List<BorderPoint> borderPoints) {
        this.borderPoints.clear();
        this.borderPoints.addAll(borderPoints);
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setBorders(Parkour.this.id, borderPoints);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }

    @Override
    public List<BorderPoint> getBorders() {
        return this.borderPoints;
    }

    @Override
    public int getRewardCooldown() {
        return this.rewardCooldown;
    }

    public void setRewardCooldown(final int rewardCooldown) {
        this.rewardCooldown = rewardCooldown;
        new BukkitRunnable(){

            public void run() {
                HubParkour.getInstance().getDbManager().setRewardCooldown(Parkour.this.id, rewardCooldown);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }
}

