/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.IParkour;
import me.block2block.hubparkour.api.events.admin.ParkourSetupEvent;
import me.block2block.hubparkour.api.plates.BorderPoint;
import me.block2block.hubparkour.api.plates.Checkpoint;
import me.block2block.hubparkour.api.plates.EndPoint;
import me.block2block.hubparkour.api.plates.PressurePlate;
import me.block2block.hubparkour.api.plates.RestartPoint;
import me.block2block.hubparkour.api.plates.StartPoint;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import me.block2block.hubparkour.utils.ItemUtil;
import org.apache.commons.lang3.Range;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetupWizard {
    private final Player player;
    private StartPoint startPoint;
    private EndPoint endPoint;
    private RestartPoint restartPoint;
    private final List<Checkpoint> checkpoints = new ArrayList<Checkpoint>();
    private String endCommand;
    private String name;
    private String checkpointCommand;
    private int currentStage;
    private int cooldown;
    private final List<BorderPoint> borderPoints = new ArrayList<BorderPoint>();

    public SetupWizard(Player player) {
        this.player = player;
        this.currentStage = 0;
        player.getInventory().addItem(new ItemStack[]{ItemUtil.ci(Material.STICK, "&2&lHubParkour Setup Stick", 1, "&rUse this item to;&rsetup your HubParkour;&rParkour.")});
        ConfigUtil.sendMessageOrDefault(player, "Messages.Commands.Admin.Setup.Given-Setup-Stick", "You have been given the setup stick.", true, Collections.emptyMap());
        ConfigUtil.sendMessageOrDefault(player, "Messages.Commands.Admin.Setup.Please-Set-Start", "Welcome to the parkour setup wizard!\n\nBefore we start, please note that the setup wizard will use your player location when clicking to register locations, not where you look when clicking the stick. When players use commands, they will get teleported facing the direction you are facing when clicking the stick.\nIn order to start, please start off by clicking where you would like your start pressure plate with the stick. Do not worry about placing any pressure plates, the plugin will do that for you! If you wish to cancel at any time, enter 'cancel' or type /parkour cancel.", true, Collections.emptyMap());
    }

    public boolean onChat(String message) {
        switch (this.currentStage) {
            case 6: {
                if (!message.equalsIgnoreCase("cancel")) {
                    if (CacheManager.getParkour(message) == null) {
                        this.name = message;
                        ++this.currentStage;
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-End-Command", "The name has been set! Please now type out your reward command for the end of your parkour into chat or type it with /parkour input [name]. If you don't want one, just type 'none'. Available placeholders are {player-uuid} and {player-name}.", true, Collections.emptyMap());
                    } else {
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Name-Taken", "That name is already taken. Please try again.", true, Collections.emptyMap());
                    }
                } else {
                    CacheManager.exitSetup();
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Setup-Cancelled", "Parkour setup was cancelled. Any points that were setup have been deleted.", true, Collections.emptyMap());
                }
                return true;
            }
            case 7: {
                if (!message.equalsIgnoreCase("cancel")) {
                    String command = message;
                    if (message.equalsIgnoreCase("none")) {
                        command = null;
                    }
                    this.endCommand = command;
                    ++this.currentStage;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Checkpoint-Command", "The End Command has been set! Please now type out your reward command for checkpoints of your parkour into chat or type it with /parkour input [name]. This command will only be executed for each reached checkpoint after they finish the parkour to prevent exploitation. If you don't want one, just type 'none'. Available placeholders are {player-uuid} and {player-name}.", true, Collections.emptyMap());
                } else {
                    CacheManager.exitSetup();
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Setup-Cancelled", "Parkour setup was cancelled. Any points that were setup have been deleted.", true, Collections.emptyMap());
                }
                return true;
            }
            case 8: {
                if (!message.equalsIgnoreCase("cancel")) {
                    String command = message;
                    if (message.equalsIgnoreCase("none")) {
                        command = null;
                    }
                    this.checkpointCommand = command;
                    ++this.currentStage;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Reward-Cooldown", "Please specify a cooldown for you rewards (only applicable when you have repeat-rewards enabled). If you do not wish to have one, please type 'none'.", true, Collections.emptyMap());
                } else {
                    CacheManager.exitSetup();
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Setup-Cancelled", "Parkour setup was cancelled. Any points that were setup have been deleted.", true, Collections.emptyMap());
                }
                return true;
            }
            case 9: {
                if (!message.equalsIgnoreCase("cancel")) {
                    String cooldown = message;
                    if (message.equalsIgnoreCase("none")) {
                        cooldown = "-1";
                    }
                    try {
                        this.cooldown = Integer.parseInt(cooldown);
                    }
                    catch (NumberFormatException e) {
                        ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Invalid-Cooldown", "That cooldown is not valid. Please try again. If you do not wish to have one, please type 'none'.", true, Collections.emptyMap());
                        return true;
                    }
                    final Parkour parkour = new Parkour(-1, this.name, this.startPoint, this.endPoint, this.checkpoints, this.restartPoint, this.borderPoints, this.checkpointCommand, this.endCommand, this.cooldown);
                    ParkourSetupEvent setupEvent = new ParkourSetupEvent((IParkour)parkour, this.player);
                    Bukkit.getPluginManager().callEvent((Event)setupEvent);
                    new BukkitRunnable(){

                        public void run() {
                            for (PressurePlate pp : parkour.getAllPoints()) {
                                pp.placeMaterial();
                                if (pp.getType() != 2) {
                                    CacheManager.addPoint(pp);
                                    continue;
                                }
                                CacheManager.addRestartPoint(pp);
                            }
                            if (HubParkour.isHolograms()) {
                                parkour.generateHolograms();
                            }
                            new BukkitRunnable(){

                                public void run() {
                                    Parkour newParkour = HubParkour.getInstance().getDbManager().addParkour(parkour);
                                    CacheManager.addParkour(newParkour);
                                    CacheManager.exitSetup();
                                    ConfigUtil.sendMessageOrDefault(SetupWizard.this.player, "Messages.Commands.Admin.Setup.Setup-Complete", "Parkour setup complete!", true, Collections.emptyMap());
                                }
                            }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
                        }
                    }.runTask((Plugin)HubParkour.getInstance());
                } else {
                    CacheManager.exitSetup();
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Setup-Cancelled", "Parkour setup was cancelled. Any points that were setup have been deleted.", true, Collections.emptyMap());
                }
                return true;
            }
        }
        if (message.equalsIgnoreCase("cancel")) {
            CacheManager.exitSetup();
            ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Setup-Cancelled", "Parkour setup was cancelled. Any points that were setup have been deleted.", true, Collections.emptyMap());
            return true;
        }
        if (message.equalsIgnoreCase("done")) {
            if (this.currentStage == 4 || this.currentStage == 5) {
                this.currentStage = 6;
                this.borderPoints.clear();
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Name", "Now, you need to set a name for your parkour! Please enter a name for your parkour into chat or type it with /parkour input [name]. It must be one word and not a duplicate. Names are compatible with formatting codes.", true, Collections.emptyMap());
                return true;
            }
            if (this.currentStage == 3) {
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Border", "Next, you need to set your border points. In order to do so, please click the stick while in the location you would like to set your border points. If you do not wish to use border points, then enter 'done' or execute /parkour done.", true, Collections.emptyMap());
                ++this.currentStage;
                return true;
            }
        }
        return false;
    }

    public void stickInteract(Location location) {
        switch (this.currentStage) {
            case 0: {
                this.startPoint = new StartPoint(location);
                ++this.currentStage;
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-End", "Start point set! Now, click where you would like your end pressure plate with your stick.", true, Collections.emptyMap());
                break;
            }
            case 1: {
                if (this.startPoint.getLocation().equals((Object)location)) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Invalid-Placement", "The place you are trying to setup that point is currently set for a different type of point. If this is a mistake, please type 'cancel' and re-setup your parkour.", true, Collections.emptyMap());
                    return;
                }
                this.endPoint = new EndPoint(location);
                ++this.currentStage;
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Respawn", "End point set! Next, you need to set your respawn point. Click the stick while standing in your respawn point.", true, Collections.emptyMap());
                break;
            }
            case 2: {
                this.restartPoint = new RestartPoint(location);
                ++this.currentStage;
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Checkpoints", "Respawn point set! Now, you need to select any checkpoints you want. Click on each checkpoint pressure plate, in order you want them completed, then enter 'done'.", true, Collections.emptyMap());
                break;
            }
            case 3: {
                for (PressurePlate pressurePlate : this.checkpoints) {
                    if (!pressurePlate.getLocation().equals((Object)location) || pressurePlate.getType() == 2) continue;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Invalid-Placement", "The place you are trying to setup that point is currently set for a different type of point. If this is a mistake, please type 'cancel' and re-setup your parkour.", true, Collections.emptyMap());
                    return;
                }
                if (this.startPoint.getLocation().equals((Object)location)) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Invalid-Placement", "The place you are trying to setup that point is currently set for a different type of point. If this is a mistake, please type 'cancel' and re-setup your parkour.", true, Collections.emptyMap());
                    return;
                }
                if (this.endPoint.getLocation().equals((Object)location)) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Invalid-Placement", "The place you are trying to setup that point is currently set for a different type of point. If this is a mistake, please type 'cancel' and re-setup your parkour.", true, Collections.emptyMap());
                    return;
                }
                this.checkpoints.add(new Checkpoint(location, this.checkpoints.size() + 1));
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Checkpoint-Added", "Checkpoint successfully added.", true, Collections.emptyMap());
                break;
            }
            case 4: {
                this.borderPoints.add(new BorderPoint(location));
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Second-Border", "Great, now set your second border point! If you do not wish to use border points, then enter 'done' or execute /parkour done.", true, Collections.emptyMap());
                ++this.currentStage;
                break;
            }
            case 5: {
                Location other = this.borderPoints.get(0).getLocation();
                Range<Double> range = Range.between(location.getX(), other.getX());
                Range<Double> rangeY = Range.between(location.getY(), other.getY());
                Range<Double> rangeZ = Range.between(location.getZ(), other.getZ());
                if (!(range.contains(this.restartPoint.getLocation().getX()) && rangeY.contains(this.restartPoint.getLocation().getY()) && rangeZ.contains(this.restartPoint.getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentStage = 4;
                    return;
                }
                if (!(range.contains(this.startPoint.getLocation().getX()) && rangeY.contains(this.startPoint.getLocation().getY()) && rangeZ.contains(this.startPoint.getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentStage = 4;
                    return;
                }
                if (!(range.contains(this.endPoint.getLocation().getX()) && rangeY.contains(this.endPoint.getLocation().getY()) && rangeZ.contains(this.endPoint.getLocation().getZ()))) {
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentStage = 4;
                    return;
                }
                for (Checkpoint checkpoint : this.checkpoints) {
                    if (range.contains(checkpoint.getLocation().getX()) && rangeY.contains(checkpoint.getLocation().getY()) && rangeZ.contains(checkpoint.getLocation().getZ())) continue;
                    ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Plates-Outside-Border", "There are currently plates outside your border! Please try again!", true, Collections.emptyMap());
                    this.currentStage = 4;
                    return;
                }
                ++this.currentStage;
                ConfigUtil.sendMessageOrDefault(this.player, "Messages.Commands.Admin.Setup.Please-Set-Name", "Now, you need to set a name for your parkour! Please enter a name for your parkour into chat or type it with /parkour input [name]. It must be one word and not a duplicate. Names are compatible with formatting codes.", true, Collections.emptyMap());
                break;
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }
}

