/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.IParkour;
import me.block2block.hubparkour.api.events.player.ParkourPlayerFailEvent;
import me.block2block.hubparkour.api.events.player.ParkourPlayerLeaveEvent;
import me.block2block.hubparkour.api.events.player.ParkourPlayerTeleportEvent;
import me.block2block.hubparkour.api.events.player.ParkourPlayerTogglePlayersEvent;
import me.block2block.hubparkour.api.items.HideItem;
import me.block2block.hubparkour.api.items.ParkourItem;
import me.block2block.hubparkour.api.items.ShowItem;
import me.block2block.hubparkour.entities.HubParkourPlayer;
import me.block2block.hubparkour.listeners.FallListener;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ItemClickListener
implements Listener {
    private final List<Player> cancelNextEvent = new ArrayList<Player>();

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (CacheManager.isParkour(e.getPlayer())) {
            if (this.cancelNextEvent.contains(e.getPlayer())) {
                this.cancelNextEvent.remove(e.getPlayer());
                return;
            }
            if (e.getAction() == Action.RIGHT_CLICK_BLOCK || e.getAction() == Action.LEFT_CLICK_BLOCK) {
                this.cancelNextEvent.add(e.getPlayer());
            }
            if (e.getItem() != null) {
                block7: for (int type : CacheManager.getItems().keySet()) {
                    if (!CacheManager.getItems().get(type).equals((Object)e.getItem())) continue;
                    e.setCancelled(true);
                    final Player p = e.getPlayer();
                    final HubParkourPlayer player = CacheManager.getPlayer(p);
                    switch (type) {
                        case 0: {
                            if (FallListener.getHasTeleported().contains(p)) {
                                return;
                            }
                            ParkourPlayerTeleportEvent event = new ParkourPlayerTeleportEvent(CacheManager.getPlayer(p).getParkour(), CacheManager.getPlayer(p), CacheManager.getPlayer(p).getParkour().getRestartPoint());
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                return;
                            }
                            p.setFallDistance(0.0f);
                            Location l = CacheManager.getPlayer(p).getParkour().getRestartPoint().getLocation().clone();
                            l.setX(l.getX() + 0.5);
                            l.setY(l.getY() + 0.5);
                            l.setZ(l.getZ() + 0.5);
                            p.setVelocity(new Vector(0, 0, 0));
                            p.teleport(l);
                            ConfigUtil.sendMessage(p, "Messages.Commands.Reset.Successful", "You have been teleported to the start.", true, Collections.emptyMap());
                            FallListener.getHasTeleported().add(p);
                            new BukkitRunnable(){

                                public void run() {
                                    FallListener.getHasTeleported().remove(p);
                                }
                            }.runTaskLater((Plugin)HubParkour.getInstance(), 5L);
                            return;
                        }
                        case 1: {
                            if (FallListener.getHasTeleported().contains(p)) {
                                return;
                            }
                            ParkourPlayerTeleportEvent event2 = new ParkourPlayerTeleportEvent(player.getParkour(), player, player.getLastReached() != 0 ? player.getParkour().getCheckpoint(player.getLastReached()) : player.getParkour().getRestartPoint());
                            Bukkit.getPluginManager().callEvent((Event)event2);
                            if (event2.isCancelled()) {
                                return;
                            }
                            p.setFallDistance(0.0f);
                            Location l2 = player.getParkour().getRestartPoint().getLocation().clone();
                            if (player.getLastReached() != 0) {
                                l2 = player.getParkour().getCheckpoint(player.getLastReached()).getLocation().clone();
                            }
                            l2.setX(l2.getX() + 0.5);
                            l2.setY(l2.getY() + 0.5);
                            l2.setZ(l2.getZ() + 0.5);
                            p.setVelocity(new Vector(0, 0, 0));
                            p.teleport(l2);
                            ConfigUtil.sendMessage(p, "Messages.Commands.Checkpoint.Successful", "You have been teleported to your last checkpoint.", true, Collections.emptyMap());
                            FallListener.getHasTeleported().add(p);
                            new BukkitRunnable(){

                                public void run() {
                                    FallListener.getHasTeleported().remove(p);
                                }
                            }.runTaskLater((Plugin)HubParkour.getInstance(), 5L);
                            return;
                        }
                        case 2: {
                            ParkourPlayerLeaveEvent leaveEvent = new ParkourPlayerLeaveEvent((IParkour)player.getParkour(), player);
                            Bukkit.getPluginManager().callEvent((Event)leaveEvent);
                            if (leaveEvent.isCancelled()) {
                                return;
                            }
                            new BukkitRunnable(){

                                public void run() {
                                    player.end(ParkourPlayerFailEvent.FailCause.LEAVE);
                                }
                            }.runTaskLater((Plugin)HubParkour.getInstance(), 1L);
                            ConfigUtil.sendMessage(p, "Messages.Commands.Leave.Left", "You have left the parkour and your progress has been reset.", true, Collections.emptyMap());
                            return;
                        }
                        case 3: {
                            ParkourPlayerTogglePlayersEvent toggleEvent = new ParkourPlayerTogglePlayersEvent(player.getParkour(), player, false);
                            Bukkit.getPluginManager().callEvent((Event)toggleEvent);
                            if (toggleEvent.isCancelled()) {
                                return;
                            }
                            ParkourItem item = null;
                            for (ParkourItem parkourItem : player.getParkourItems()) {
                                if (parkourItem.getType() != 3) continue;
                                item = parkourItem;
                                break;
                            }
                            player.getParkourItems().remove(item);
                            if (item == null) break;
                            ShowItem showItem = new ShowItem((HideItem)item);
                            player.getParkourItems().add(showItem);
                            player.getPlayer().getInventory().setItem(showItem.getSlot(), showItem.getItem());
                            for (Player pl : Bukkit.getOnlinePlayers()) {
                                if (!player.getPlayer().canSee(pl)) continue;
                                showItem.getHiddenPlayers().add(pl);
                                p.hidePlayer(pl);
                            }
                            continue block7;
                        }
                        case 4: {
                            ParkourPlayerTogglePlayersEvent toggleEvent = new ParkourPlayerTogglePlayersEvent(player.getParkour(), player, true);
                            Bukkit.getPluginManager().callEvent((Event)toggleEvent);
                            if (toggleEvent.isCancelled()) {
                                return;
                            }
                            ParkourItem item = null;
                            for (ParkourItem parkourItem : player.getParkourItems()) {
                                if (parkourItem.getType() != 4) continue;
                                item = parkourItem;
                                break;
                            }
                            player.getParkourItems().remove(item);
                            if (item == null) break;
                            HideItem hideItem = new HideItem((ShowItem)item);
                            player.getParkourItems().add(hideItem);
                            player.getPlayer().getInventory().setItem(hideItem.getSlot(), hideItem.getItem());
                            for (Player player1 : ((ShowItem)item).getHiddenPlayers()) {
                                if (!player1.isOnline()) continue;
                                player.getPlayer().showPlayer(player1);
                            }
                            continue block7;
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBuild(BlockPlaceEvent e) {
        if (CacheManager.isParkour(e.getPlayer()) && e.getBlockPlaced() != null) {
            for (int type : CacheManager.getItems().keySet()) {
                if (!CacheManager.getItems().get(type).getType().equals((Object)e.getBlockPlaced().getType())) continue;
                e.setCancelled(true);
            }
        }
    }
}

