/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.signs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import me.block2block.hubparkour.api.events.player.ParkourPlayerFailEvent;
import me.block2block.hubparkour.api.events.player.ParkourPlayerStartEvent;
import me.block2block.hubparkour.api.signs.ClickableSign;
import me.block2block.hubparkour.entities.HubParkourPlayer;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.managers.CacheManager;
import me.block2block.hubparkour.utils.ConfigUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;

public class StartClickableSign
extends ClickableSign {
    public StartClickableSign(Parkour parkour, Sign signState) {
        super(parkour, signState);
    }

    @Override
    public void refresh() {
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("&2&l[PARKOUR]");
        defaultList.add("&a{parkour-name}");
        defaultList.add("{amount-of-players} players");
        defaultList.add("Click to start!");
        int counter = 0;
        for (String s : ConfigUtil.getStringList("Messages.Signs.Start", defaultList)) {
            this.signState.setLine(counter, ChatColor.translateAlternateColorCodes((char)'&', (String)s.replace("{parkour-name}", this.parkour.getName()).replace("{amount-of-players}", this.parkour.getPlayers().size() + "")));
            if (++counter != 4) continue;
            break;
        }
        this.signState.update(true);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void onClick(Player p) {
        if (CacheManager.isSomeoneEdit() && this.parkour.equals(CacheManager.getEditWizard().getParkour())) {
            ConfigUtil.sendMessageOrDefault(p, "Messages.Parkour.Currently-Being-Edited", "This parkour is currently in being modified by an admin. Please wait to attempt this parkour!", true, Collections.emptyMap());
            return;
        }
        if (CacheManager.isParkour(p)) {
            if (CacheManager.getPlayer(p).getParkour().getId() == this.parkour.getId()) {
                CacheManager.getPlayer(p).restart();
                ConfigUtil.sendMessageOrDefault(p, "Messages.Parkour.Restarted", "You have restarted the parkour! Your time has been reset to 0!", true, Collections.emptyMap());
                return;
            }
            if (ConfigUtil.getBoolean("Settings.Start-When-In-Parkour", false)) {
                CacheManager.getPlayer(p).end(ParkourPlayerFailEvent.FailCause.NEW_PARKOUR);
                p.teleport(this.parkour.getRestartPoint().getLocation());
                HubParkourPlayer player = new HubParkourPlayer(p, (Parkour)this.parkour);
                ParkourPlayerStartEvent event = new ParkourPlayerStartEvent(this.parkour, player, player.getStartTime());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.parkour.playerStart(player);
                CacheManager.playerStart(player);
                if (ConfigUtil.getBoolean("Settings.Exploit-Prevention.Remove-Potion-Effects", true)) {
                    for (PotionEffect effect : p.getActivePotionEffects()) {
                        p.removePotionEffect(effect.getType());
                    }
                }
                if (ConfigUtil.getBoolean("Settings.Exploit-Prevention.Remove-Fly", true)) {
                    p.setFlying(false);
                    if (Material.getMaterial((String)"ELYTRA") != null) {
                        p.setGliding(false);
                    }
                }
                player.giveItems();
                HashMap<String, String> bindings = new HashMap<String, String>();
                bindings.put("parkour-name", this.parkour.getName());
                ConfigUtil.sendMessageOrDefault(p, "Messages.Parkour.Started", "You have started the &a{parkour-name} &rparkour!", true, bindings);
                return;
            }
            ConfigUtil.sendMessageOrDefault(p, "Messages.Parkour.Already-In-Parkour", "You are already doing a parkour. If you wish to leave the current parkour and start a new one, do /parkour leave.", true, Collections.emptyMap());
            return;
        }
        p.teleport(this.parkour.getRestartPoint().getLocation());
        Parkour parkour = (Parkour)this.parkour;
        HubParkourPlayer player = new HubParkourPlayer(p, parkour);
        ParkourPlayerStartEvent event = new ParkourPlayerStartEvent(parkour, player, player.getStartTime());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        parkour.playerStart(player);
        CacheManager.playerStart(player);
        if (ConfigUtil.getBoolean("Settings.Exploit-Prevention.Remove-Potion-Effects", true)) {
            for (PotionEffect effect : p.getActivePotionEffects()) {
                p.removePotionEffect(effect.getType());
            }
        }
        if (ConfigUtil.getBoolean("Settings.Exploit-Prevention.Remove-Fly", true)) {
            p.setFlying(false);
            if (Material.getMaterial((String)"ELYTRA") != null) {
                p.setGliding(false);
            }
        }
        player.giveItems();
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("parkour-name", parkour.getName());
        ConfigUtil.sendMessageOrDefault(p, "Messages.Parkour.Started", "You have started the &a{parkour-name} &rparkour!", true, bindings);
    }
}

