/*
 * Decompiled with CFR 0.152.
 */
package me.block2block.hubparkour.signs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import me.block2block.hubparkour.HubParkour;
import me.block2block.hubparkour.api.signs.ClickableSign;
import me.block2block.hubparkour.entities.Parkour;
import me.block2block.hubparkour.entities.Statistics;
import me.block2block.hubparkour.utils.ConfigUtil;
import org.bukkit.ChatColor;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StatsClickableSign
extends ClickableSign {
    public StatsClickableSign(Parkour parkour, Sign signState) {
        super(parkour, signState);
    }

    @Override
    public void refresh() {
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("&2&l[PARKOUR]");
        defaultList.add("&a{parkour-name}");
        defaultList.add("");
        defaultList.add("Click to view stats!");
        int counter = 0;
        for (String s : ConfigUtil.getStringList("Messages.Signs.Stats", defaultList)) {
            this.signState.setLine(counter, ChatColor.translateAlternateColorCodes((char)'&', (String)s.replace("{parkour-name}", this.parkour.getName())));
            if (++counter != 4) continue;
            break;
        }
        this.signState.update(true);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void onClick(final Player player) {
        new BukkitRunnable(){

            public void run() {
                Statistics statistics = HubParkour.getInstance().getDbManager().getParkourStatistics(player, (Parkour)StatsClickableSign.this.parkour);
                if (statistics.getAttempts().size() == 0) {
                    ConfigUtil.sendMessageOrDefault(player, "Messages.Commands.Stats.No-Parkour-Stats", "No stats have been tracked for you in this parkour yet. Attempt this parkour to earn stats!", true, Collections.emptyMap());
                    return;
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> defaultList = new ArrayList<String>();
                defaultList.add("Your stats for parkour &a{parkour-name}&r:");
                defaultList.add("&aParkour attempts:&r {attempts}");
                defaultList.add("&aParkour completions:&r {completions}");
                defaultList.add("&aTotal jumps:&r {jumps}");
                defaultList.add("&aTotal checkpoints hit:&r {checkpoints}");
                defaultList.add("&aTotal distance travelled:&r {distance} blocks");
                defaultList.add("&aTotal time in parkour:&r {time}");
                for (String s : ConfigUtil.getStringList("Messages.Commands.Stats.Parkour-Stats", defaultList)) {
                    sb.append(s).append("\n");
                }
                HashMap<String, String> bindings = new HashMap<String, String>();
                bindings.put("parkour-name", StatsClickableSign.this.parkour.getName());
                bindings.put("attempts", statistics.getAttempts().get(StatsClickableSign.this.parkour.getId()) + "");
                bindings.put("completions", statistics.getCompletions().get(StatsClickableSign.this.parkour.getId()) + "");
                bindings.put("jumps", statistics.getJumps().get(StatsClickableSign.this.parkour.getId()) + "");
                bindings.put("distance", String.format("%.2f", statistics.getTotalDistanceTravelled().get(StatsClickableSign.this.parkour.getId())));
                bindings.put("time", ConfigUtil.formatTime(statistics.getTotalTime().get(StatsClickableSign.this.parkour.getId())));
                bindings.put("checkpoints", statistics.getCheckpointsHit().get(StatsClickableSign.this.parkour.getId()) + "");
                ConfigUtil.sendMessageOrDefault(player, "Messages.Commands.Stats.Parkour-Stats", sb.toString(), true, bindings);
            }
        }.runTaskAsynchronously((Plugin)HubParkour.getInstance());
    }
}

