/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass;

import club.mher.compass.Metrics;
import club.mher.compass.command.CompassMenuCommand;
import club.mher.compass.data.MainConfig;
import club.mher.compass.data.MessagesData;
import club.mher.compass.listener.GameListener;
import club.mher.compass.listener.MenuListener;
import club.mher.compass.listener.QuickBuyListener;
import club.mher.compass.support.VaultSupport;
import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Compass
extends JavaPlugin {
    private static Compass instance;
    private static BedWars bedWars;
    private static MainConfig mainConfig;
    private static final HashMap<IArena, HashMap<UUID, ITeam>> trackingArenaMap;
    private static boolean isUsingVaultChat;
    private static boolean isUsingPapi;
    private static VaultSupport vault;
    public static final String VERSION;
    public static String PLUGIN_VERSION;

    public void onEnable() {
        instance = this;
        if (!Bukkit.getPluginManager().isPluginEnabled("BedWars1058")) {
            this.getLogger().severe("BedWars1058 was not found. Disabling...");
            this.setEnabled(false);
            return;
        }
        long start = System.currentTimeMillis();
        new Metrics(this, 11186);
        PLUGIN_VERSION = this.getDescription().getVersion();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            isUsingPapi = true;
        }
        vault = new VaultSupport();
        isUsingVaultChat = vault.setupChat();
        bedWars = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
        new CompassMenuCommand(bedWars.getBedWarsCommand(), "compass");
        mainConfig = new MainConfig((Plugin)this, "config", bedWars.getAddonsPath().getPath() + File.separator + "Compass");
        mainConfig.reload();
        new MessagesData();
        Arrays.asList(new MenuListener(), new GameListener(), new QuickBuyListener()).forEach(l -> Bukkit.getPluginManager().registerEvents(l, (Plugin)this));
        this.getLogger().log(Level.INFO, "Successfully loaded in " + (System.currentTimeMillis() - start) + "ms");
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        trackingArenaMap.clear();
    }

    public static void setTrackingTeam(IArena arena, UUID uuid, ITeam team) {
        if (trackingArenaMap.get(arena) != null) {
            Compass.getTrackingTeamMap(arena).put(uuid, team);
            return;
        }
        HashMap<UUID, ITeam> map = new HashMap<UUID, ITeam>();
        map.put(uuid, team);
        trackingArenaMap.put(arena, map);
    }

    public static boolean isTracking(IArena arena, UUID uuid) {
        if (trackingArenaMap.containsKey(arena)) {
            return trackingArenaMap.get(arena).containsKey(uuid);
        }
        return false;
    }

    public static HashMap<UUID, ITeam> getTrackingTeamMap(IArena arena) {
        return trackingArenaMap.get(arena);
    }

    public static ITeam getTrackingTeam(IArena arena, UUID uuid) {
        return trackingArenaMap.get(arena).get(uuid);
    }

    public static void removeTrackingTeam(IArena arena, UUID uuid) {
        trackingArenaMap.get(arena).remove(uuid);
    }

    public static void removeTrackingArena(IArena arena) {
        trackingArenaMap.remove(arena);
    }

    public static Compass getInstance() {
        return instance;
    }

    public static BedWars getBedWars() {
        return bedWars;
    }

    public static MainConfig getMainConfig() {
        return mainConfig;
    }

    public static HashMap<IArena, HashMap<UUID, ITeam>> getTrackingArenaMap() {
        return trackingArenaMap;
    }

    public static boolean isUsingVaultChat() {
        return isUsingVaultChat;
    }

    public static boolean isUsingPapi() {
        return isUsingPapi;
    }

    public static VaultSupport getVault() {
        return vault;
    }

    static {
        trackingArenaMap = new HashMap();
        isUsingVaultChat = false;
        isUsingPapi = false;
        VERSION = Bukkit.getServer().getClass().getName().split("\\.")[3];
    }
}

