/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.menu.menus.communicationMenus;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.Menu;
import club.mher.compass.menu.menus.CommunicationsMenu;
import club.mher.compass.util.MessagingUtil;
import club.mher.compass.util.NBTItem;
import club.mher.compass.util.TextUtil;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.language.Language;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TeamSelector
extends Menu {
    Language lang;
    YamlConfiguration yml;
    List<Integer> slots;
    IArena arena;
    ITeam team;
    String path;
    HashMap<Integer, ITeam> teamMap = new HashMap();

    public TeamSelector(Player player, ITeam team, String path) {
        super(player);
        this.lang = MessagesData.getLang(player.getPlayer());
        this.yml = this.lang.getYml();
        this.slots = new ArrayList<Integer>();
        this.team = team;
        this.arena = team.getArena();
        this.path = path;
        for (String s : Compass.getMainConfig().getYml().getString("communication-menus.teams.slots").split(",")) {
            int i;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                continue;
            }
            this.slots.add(i);
        }
    }

    @Override
    public String getMenuName() {
        return this.yml.getString("addons.compass.communication-menus.teams.title");
    }

    @Override
    public int getSlots() {
        return Compass.getMainConfig().getInt("communication-menus.teams.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        NBTItem nbti = new NBTItem(e.getCurrentItem());
        Player player = (Player)e.getWhoClicked();
        if (!Compass.getBedWars().getArenaUtil().isPlaying(player)) {
            return;
        }
        IArena a = Compass.getBedWars().getArenaUtil().getArenaByPlayer(player);
        if (a.isSpectator(player)) {
            return;
        }
        if (this.team.getMembers().size() <= 1) {
            return;
        }
        switch (nbti.getString("data")) {
            case "back-item": {
                new CommunicationsMenu(player, this.arena).open();
                break;
            }
            case "team-item": {
                MessagingUtil.teamMessage(player, this.team, nbti.getString("path"), this.teamMap.get(e.getSlot()));
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index = 0;
        for (ITeam t : this.arena.getTeams()) {
            if (t.getMembers().isEmpty() || t.equals(this.team) || this.slots.size() <= index) continue;
            this.inventory.setItem(this.slots.get(index).intValue(), this.getTeamItem(Compass.getMainConfig().getItem(this.player, "menus.tracker-menu.team-item", false, null), t));
            this.teamMap.put(this.slots.get(index), t);
            ++index;
        }
        NBTItem nbtBack = new NBTItem(Compass.getMainConfig().getItem(this.player, "communication-menus.teams.back-item", true, "back-item"));
        this.inventory.setItem(nbtBack.getInteger("slot").intValue(), nbtBack.getItem());
    }

    private ItemStack getTeamItem(ItemStack itemStack, ITeam team) {
        String displayName = this.yml.getString(this.path).replace("{team}", team.getColor().chat() + "\u00a7l" + team.getDisplayName(this.lang));
        itemStack = Compass.getBedWars().getVersionSupport().colourItem(itemStack, team);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(TextUtil.colorize(displayName));
        ArrayList newLore = new ArrayList();
        this.yml.getStringList("addons.compass.communication-menus.lore").forEach(s -> newLore.add(TextUtil.colorize(s.replace("{message}", displayName))));
        itemMeta.setLore(newLore);
        itemStack.setItemMeta(itemMeta);
        NBTItem nbtItem = new NBTItem(itemStack);
        nbtItem.setString("path", this.path);
        nbtItem.setString("data", "team-item");
        return nbtItem.getItem();
    }
}

