/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.util;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.util.TextUtil;
import club.mher.compass.util.VersionUtil;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.language.Language;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessagingUtil {
    public static void simpleMessage(Player player, ITeam team, String path) {
        player.closeInventory();
        team.getMembers().forEach(p -> {
            YamlConfiguration yml = MessagesData.getYml(p);
            String formatted = yml.getString("addons.compass.team-message-format").replace("{player}", player.getDisplayName()).replace("{message}", yml.getString(path));
            if (Compass.isUsingVaultChat()) {
                formatted = Compass.getVault().setPlaceholders(formatted, player);
            }
            if (Compass.isUsingPapi()) {
                formatted = PlaceholderAPI.setPlaceholders((Player)player, (String)formatted);
            }
            p.sendMessage(TextUtil.colorize(formatted));
            VersionUtil.playSound(p, Compass.getMainConfig().getString("team-message-sound"));
        });
    }

    public static void resourceMessage(Player player, ITeam team, String path, String resourcePath) {
        player.closeInventory();
        team.getMembers().forEach(p -> {
            YamlConfiguration yml = MessagesData.getYml(p);
            String formatted = yml.getString("addons.compass.team-message-format").replace("{player}", player.getDisplayName()).replace("{message}", yml.getString(path).replace("{resource}", yml.getString("addons.compass.communication-menus.resources." + resourcePath + ".resource-name")));
            if (Compass.isUsingVaultChat()) {
                formatted = Compass.getVault().setPlaceholders(formatted, player);
            }
            if (Compass.isUsingPapi()) {
                formatted = PlaceholderAPI.setPlaceholders((Player)player, (String)formatted);
            }
            p.sendMessage(TextUtil.colorize(formatted));
            VersionUtil.playSound(p, Compass.getMainConfig().getString("team-message-sound"));
        });
    }

    public static void teamMessage(Player player, ITeam team, String path, ITeam specifiedTeam) {
        player.closeInventory();
        team.getMembers().forEach(p -> {
            Language lang = MessagesData.getLang(p);
            YamlConfiguration yml = lang.getYml();
            String formatted = yml.getString("addons.compass.team-message-format").replace("{player}", player.getDisplayName()).replace("{message}", yml.getString(path).replace("{team}", specifiedTeam.getColor().chat() + "\u00a7l" + specifiedTeam.getDisplayName(lang)));
            if (Compass.isUsingVaultChat()) {
                formatted = Compass.getVault().setPlaceholders(formatted, player);
            }
            if (Compass.isUsingPapi()) {
                formatted = PlaceholderAPI.setPlaceholders((Player)player, (String)formatted);
            }
            p.sendMessage(TextUtil.colorize(formatted));
            VersionUtil.playSound(p, Compass.getMainConfig().getString("team-message-sound"));
        });
    }
}

