/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import us.ajg0702.leaderboards.Main;

public class Downloader {
    static Downloader instance;
    Main pl;
    List<Class> classes = new ArrayList<Class>();

    public static Downloader getInstance() {
        return instance;
    }

    public static Downloader getInstance(Main pl) {
        if (instance == null) {
            instance = new Downloader(pl);
        }
        return instance;
    }

    private Downloader(Main pl) {
        this.pl = pl;
    }

    public void downloadAndLoad() {
        try {
            String cookies;
            String newUrl;
            File f = new File(this.pl.getDataFolder().getAbsolutePath() + File.separator + "lib" + File.separator);
            if (f.exists()) {
                this.loadClasses();
                return;
            }
            f.mkdirs();
            URL website = new URL("https://ajg0702.us/pl/ajLeaderboards/libs/sqlite.jar");
            HttpURLConnection con = (HttpURLConnection)website.openConnection();
            con.addRequestProperty("User-Agent", "ajLeaderboards/" + this.pl.getDescription().getVersion());
            con.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            boolean redirect = false;
            int status = con.getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                redirect = true;
            }
            if (redirect) {
                newUrl = con.getHeaderField("Location");
                cookies = con.getHeaderField("Set-Cookie");
                con = (HttpURLConnection)new URL(newUrl).openConnection();
                con.setRequestProperty("Cookie", cookies);
                con.addRequestProperty("User-Agent", "ajLeaderboards/" + this.pl.getDescription().getVersion());
                System.out.println("Redirect to URL : " + newUrl);
            }
            redirect = false;
            status = con.getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                redirect = true;
            }
            if (redirect) {
                newUrl = con.getHeaderField("Location");
                cookies = con.getHeaderField("Set-Cookie");
                con = (HttpURLConnection)new URL(newUrl).openConnection();
                con.setRequestProperty("Cookie", cookies);
                con.setRequestProperty("Connection", "Connection: close");
                con.addRequestProperty("User-Agent", "ajLeaderboards/" + this.pl.getDescription().getVersion());
                System.out.println("Redirect to URL : " + newUrl);
            }
            ReadableByteChannel rbc = Channels.newChannel(con.getInputStream());
            FileOutputStream fos = new FileOutputStream(this.pl.getDataFolder().getAbsolutePath() + File.separator + "lib" + File.separator + "sqlite.jar");
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            this.loadClasses();
        }
        catch (Exception e) {
            this.pl.getLogger().warning("An error occured while trying to download lib:");
            e.printStackTrace();
            return;
        }
    }

    private void loadClasses() throws IOException {
        String pathToJar = this.pl.getDataFolder().getAbsolutePath() + File.separator + "lib" + File.separator + "sqlite.jar";
        JarFile jarFile = new JarFile(pathToJar);
        Enumeration<JarEntry> e = jarFile.entries();
        URL[] urls = new URL[]{new URL("jar:file:" + pathToJar + "!/")};
        URLClassLoader cl = URLClassLoader.newInstance(urls);
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(".class")) {
                this.pl.getLogger().info("[s] " + je.getName());
                continue;
            }
            this.pl.getLogger().info("[l] " + je.getName());
            String className = je.getName().substring(0, je.getName().length() - 6);
            className = className.replace('/', '.');
            try {
                this.classes.add(cl.loadClass(className));
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        jarFile.close();
    }
}

