/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards;

import java.util.LinkedHashMap;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import us.ajg0702.leaderboards.Commands;
import us.ajg0702.leaderboards.Downloader;
import us.ajg0702.leaderboards.Listeners;
import us.ajg0702.leaderboards.Placeholders;
import us.ajg0702.leaderboards.boards.TopManager;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.heads.HeadManager;
import us.ajg0702.leaderboards.libs.bukkit.Metrics;
import us.ajg0702.leaderboards.libs.spigot.Config;
import us.ajg0702.leaderboards.libs.spigot.Messages;
import us.ajg0702.leaderboards.signs.SignManager;

public class Main
extends JavaPlugin {
    Config config;
    Metrics metrics;
    Commands commands;
    Messages msgs;
    boolean vault = false;
    Chat vaultChat;
    int updateTaskId = -1;

    public void onEnable() {
        Downloader.getInstance(this);
        Cache cache = Cache.getInstance(this);
        this.commands = new Commands(this);
        this.getCommand("ajleaderboards").setExecutor((CommandExecutor)this.commands);
        this.getCommand("ajleaderboards").setTabCompleter((TabCompleter)this.commands);
        this.config = new Config(this);
        Placeholders placeholders = new Placeholders(this);
        placeholders.register();
        TopManager.getInstance(this);
        LinkedHashMap<String, String> dmsgs = new LinkedHashMap<String, String>();
        dmsgs.put("signs.top.1", "&7&m       &r #{POSITION} &7&m       ");
        dmsgs.put("signs.top.2", "&6{NAME}");
        dmsgs.put("signs.top.3", "&e{VALUE} {VALUENAME}");
        dmsgs.put("signs.top.4", "&7&m                   ");
        dmsgs.put("formatted.k", "k");
        dmsgs.put("formatted.m", "m");
        dmsgs.put("formatted.t", "t");
        dmsgs.put("formatted.b", "b");
        dmsgs.put("formatted.q", "q");
        this.msgs = Messages.getInstance(this, dmsgs);
        HeadManager.getInstance(this);
        this.reloadInterval();
        this.metrics = new Metrics((Plugin)this, 9338);
        Bukkit.getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        SignManager.getInstance(this);
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
                RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
                if (rsp == null) {
                    this.vault = false;
                    this.getLogger().warning("Vault prefix hook failed! Make sure you have a plugin that implements chat (e.g. Luckperms)");
                } else {
                    this.vaultChat = (Chat)rsp.getProvider();
                    this.vault = this.vaultChat != null;
                }
            }
        });
        this.getLogger().info("Plugin enabled! " + Cache.getInstance().getBoards().size() + " leaderboards loaded.");
    }

    public Messages getMessages() {
        return this.msgs;
    }

    public void reloadInterval() {
        if (this.updateTaskId != -1) {
            try {
                Bukkit.getScheduler().cancelTask(this.updateTaskId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateTaskId = -1;
        }
        this.updateTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                Cache.getInstance().updatePlayerStats((OfflinePlayer)p);
            }
        }, 200L, (long)this.config.getInt("stat-refresh").intValue()).getTaskId();
    }

    public Config getAConfig() {
        return this.config;
    }

    public boolean hasVault() {
        return this.vault;
    }

    public Chat getVaultChat() {
        return this.vaultChat;
    }
}

