/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TopManager;
import us.ajg0702.leaderboards.cache.Cache;

public class Placeholders
extends PlaceholderExpansion {
    Main pl;
    Pattern highNamePattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_name");
    Pattern highValuePattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_value");
    Pattern highValueFormattedPattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_value_formatted");
    Pattern highValueRawPattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_rawvalue");
    Pattern highSuffixPattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_suffix");
    Pattern highPrefixPattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_prefix");
    Pattern highColorPattern = Pattern.compile("lb_(.*)_([1-9][0-9]*)_color");
    Pattern positionPattern = Pattern.compile("position_(.*)");
    Pattern valuePattern = Pattern.compile("value_(.*)");
    Pattern valueFormattedPattern = Pattern.compile("value_(.*)_formatted");

    public Placeholders(Main pl) {
        this.pl = pl;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "ajgeiss0702";
    }

    public boolean persist() {
        return true;
    }

    public String getIdentifier() {
        return "ajlb";
    }

    public String getVersion() {
        return this.pl.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        Matcher highNameMatcher = this.highNamePattern.matcher(identifier);
        if (highNameMatcher.find()) {
            String board = highNameMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highNameMatcher.group(2)), board);
            return r.getPlayer();
        }
        Matcher highPrefixMatcher = this.highPrefixPattern.matcher(identifier);
        if (highPrefixMatcher.find()) {
            String board = highPrefixMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highPrefixMatcher.group(2)), board);
            return r.getPrefix();
        }
        Matcher highSuffixMatcher = this.highSuffixPattern.matcher(identifier);
        if (highSuffixMatcher.find()) {
            String board = highSuffixMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highSuffixMatcher.group(2)), board);
            return r.getSuffix();
        }
        Matcher highColorMatcher = this.highColorPattern.matcher(identifier);
        if (highColorMatcher.find()) {
            String board = highColorMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highColorMatcher.group(2)), board);
            if (r.getPrefix().isEmpty()) {
                return "";
            }
            String prefix = r.getPrefix();
            StringBuilder colors = new StringBuilder();
            int i = 0;
            for (char c : prefix.toCharArray()) {
                if (i == prefix.length() - 1) break;
                if (c == '&' || c == '\u00a7') {
                    colors.append(c);
                    colors.append(prefix.charAt(i + 1));
                }
                ++i;
            }
            return colors.toString();
        }
        Matcher highValueRawMatcher = this.highValueRawPattern.matcher(identifier);
        if (highValueRawMatcher.find()) {
            String board = highValueRawMatcher.group(1);
            StatEntry r = Cache.getInstance().getStat(Integer.parseInt(highValueRawMatcher.group(2)), board);
            DecimalFormat df = new DecimalFormat("#.##");
            return df.format(r.getScore());
        }
        Matcher highValueFormattedMatcher = this.highValueFormattedPattern.matcher(identifier);
        if (highValueFormattedMatcher.find()) {
            String board = highValueFormattedMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highValueFormattedMatcher.group(2)), board);
            return r.getScoreFormatted();
        }
        Matcher highValueMatcher = this.highValuePattern.matcher(identifier);
        if (highValueMatcher.find()) {
            String board = highValueMatcher.group(1);
            StatEntry r = TopManager.getInstance().getStat(Integer.parseInt(highValueMatcher.group(2)), board);
            return r.getScorePretty();
        }
        Matcher positionMatcher = this.positionPattern.matcher(identifier);
        if (positionMatcher.find()) {
            String board = positionMatcher.group(1);
            return Cache.getInstance().getStatEntry(player, board).getPosition() + "";
        }
        Matcher valueMatcher = this.valuePattern.matcher(identifier);
        if (valueMatcher.find()) {
            String board = valueMatcher.group(1);
            return Cache.getInstance().getStatEntry(player, board).getScorePretty();
        }
        Matcher valueFormattedMatcher = this.valueFormattedPattern.matcher(identifier);
        if (valueFormattedMatcher.find()) {
            String board = valueFormattedMatcher.group(1);
            return Cache.getInstance().getStatEntry(player, board).getScoreFormatted();
        }
        return null;
    }
}

