/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.boards;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.UUID;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.libs.spigot.Config;
import us.ajg0702.leaderboards.libs.spigot.Messages;

public class StatEntry {
    String player;
    String prefix;
    String suffix;
    UUID playerID;
    int position;
    String board;
    private Cache cache;
    private Messages msgs;
    String k = "k";
    String m = "m";
    String b = "b";
    String t = "t";
    String q = "q";
    double score;

    public StatEntry(int position, String board, String prefix, String player, UUID playerID, String suffix, double score) {
        this.player = player;
        this.score = score;
        this.prefix = prefix;
        this.suffix = suffix;
        this.playerID = playerID;
        try {
            this.cache = Cache.getInstance();
            this.msgs = this.cache.getPlugin().getMessages();
            this.k = this.msgs.get("formatted.k");
            this.m = this.msgs.get("formatted.m");
            this.b = this.msgs.get("formatted.b");
            this.t = this.msgs.get("formatted.t");
            this.q = this.msgs.get("formatted.q");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.position = position;
        this.board = board;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPlayer() {
        return this.player;
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public int getPosition() {
        return this.position;
    }

    public String getBoard() {
        return this.board;
    }

    public double getScore() {
        return this.score;
    }

    public String getScoreFormatted() {
        if (this.cache != null) {
            Config config = this.cache.getPlugin().getAConfig();
            if (this.score == 0.0 && this.player.equals(config.getString("no-data-name"))) {
                return config.getString("no-data-score");
            }
        } else if (this.score == 0.0 && this.player.equals("---")) {
            return "---";
        }
        if (this.score < 1000.0) {
            return this.formatNumber(this.score);
        }
        if (this.score < 1000000.0) {
            return this.formatNumber(this.score / 1000.0) + this.k;
        }
        if (this.score < 1.0E9) {
            return this.formatNumber(this.score / 1000000.0) + this.m;
        }
        if (this.score < 1.0E12) {
            return this.formatNumber(this.score / 1.0E9) + this.b;
        }
        if (this.score < 1.0E15) {
            return this.formatNumber(this.score / 1.0E12) + this.t;
        }
        if (this.score < 1.0E18) {
            return this.formatNumber(this.score / 1.0E15) + this.q;
        }
        return this.getScorePretty();
    }

    private String formatNumber(double d) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(0);
        return format.format(d);
    }

    public String getScorePretty() {
        if (this.cache != null) {
            Config config = this.cache.getPlugin().getAConfig();
            if (this.score == 0.0 && this.player.equals(config.getString("no-data-name"))) {
                return config.getString("no-data-score");
            }
        } else if (this.score == 0.0 && this.player.equals("---")) {
            return "---";
        }
        return this.addCommas(this.score);
    }

    private String addCommas(double number) {
        String comma = this.cache != null ? Cache.getInstance().getPlugin().getAConfig().getString("comma") : ",";
        DecimalFormat df = new DecimalFormat("#.##");
        String ns = df.format(number);
        int ic = 0;
        if (ns.indexOf(".") == ns.length() - 2 && ns.charAt(ns.length() - 1) == '0' && ns.length() >= 3) {
            ns = ns.substring(0, ns.length() - 2);
        }
        String mn = ns.contains(".") ? ns.substring(0, ns.indexOf(".")) : ns;
        for (int i = mn.length() - 1; i > 0; --i) {
            if (++ic % 3 != 0) continue;
            mn = mn.substring(0, i) + comma + mn.substring(i);
        }
        if ((ns = ns.contains(".") ? mn + ns.substring(ns.indexOf(".")) : mn).charAt(ns.length() - 1) == ',') {
            ns = ns.substring(0, ns.length() - 1);
        }
        return ns;
    }
}

