/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.boards;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.cache.Cache;

public class TopManager {
    private static TopManager instance;
    private final Main plugin;
    private HashMap<String, HashMap<Integer, Long>> lastGet = new HashMap();
    private HashMap<String, HashMap<Integer, StatEntry>> cache = new HashMap();

    public static TopManager getInstance() {
        return instance;
    }

    public static TopManager getInstance(Main pl) {
        if (instance == null) {
            instance = new TopManager(pl);
        }
        return instance;
    }

    private TopManager(Main pl) {
        this.plugin = pl;
    }

    public StatEntry getStat(int position, String board) {
        if (!this.cache.containsKey(board)) {
            this.cache.put(board, new HashMap());
        }
        if (!this.lastGet.containsKey(board)) {
            this.lastGet.put(board, new HashMap());
        }
        if (this.cache.get(board).containsKey(position)) {
            if (System.currentTimeMillis() - this.lastGet.get(board).get(position) > 5000L) {
                this.lastGet.get(board).put(position, System.currentTimeMillis());
                this.fetchPositionAsync(position, board);
            }
            return this.cache.get(board).get(position);
        }
        this.lastGet.get(board).put(position, System.currentTimeMillis());
        return this.fetchPosition(position, board);
    }

    private void fetchPositionAsync(int position, String board) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.fetchPosition(position, board));
    }

    private StatEntry fetchPosition(int position, String board) {
        StatEntry te = Cache.getInstance().getStat(position, board);
        this.cache.get(board).put(position, te);
        return te;
    }
}

