/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.cache.CacheMethod;
import us.ajg0702.leaderboards.cache.methods.MysqlMethod;
import us.ajg0702.leaderboards.cache.methods.SqliteMethod;
import us.ajg0702.leaderboards.libs.spigot.ConfigFile;

public class Cache {
    static Cache INSTANCE;
    ConfigFile storageConfig;
    Main pl;
    CacheMethod method;
    String tablePrefix;
    private static final HashMap<String, String> altPlaceholders;

    public static Cache getInstance() {
        return INSTANCE;
    }

    public static Cache getInstance(Main pl) {
        if (INSTANCE == null) {
            INSTANCE = new Cache(pl);
        }
        return INSTANCE;
    }

    public Main getPlugin() {
        return this.pl;
    }

    private Cache(Main pl) {
        this.pl = pl;
        pl.getDataFolder().mkdirs();
        this.storageConfig = new ConfigFile(pl, "cache_storage.yml");
        if (this.storageConfig.getString("method").equalsIgnoreCase("mysql")) {
            pl.getLogger().info("Using MySQL for board cache. (" + this.storageConfig.getString("method") + ")");
            this.method = new MysqlMethod();
            this.tablePrefix = this.storageConfig.getString("table_prefix");
        } else {
            pl.getLogger().info("Using SQLite for board cache. (" + this.storageConfig.getString("method") + ")");
            this.method = new SqliteMethod();
            this.tablePrefix = "";
        }
        this.method.init(pl, this.storageConfig, this);
    }

    public StatEntry getStat(int position, String board) {
        if (!this.boardExists(board)) {
            return new StatEntry(position, board, "", "Board does not exist", null, "", 0.0);
        }
        try {
            String suffix;
            String prefix;
            String name;
            double value;
            String uuidraw;
            ResultSet r;
            Statement statement;
            Connection conn;
            block8: {
                conn = this.method.getConnection();
                statement = conn.createStatement();
                r = statement.executeQuery("select id,value,namecache,prefixcache,suffixcache from `" + this.tablePrefix + board + "` order by value desc limit " + (position - 1) + "," + position);
                uuidraw = null;
                value = -1.0;
                name = "-Unknown-";
                prefix = "";
                suffix = "";
                if (this.method instanceof MysqlMethod) {
                    r.next();
                }
                try {
                    uuidraw = r.getString("id");
                    value = r.getDouble("value");
                    name = r.getString("namecache");
                    prefix = r.getString("prefixcache");
                    suffix = r.getString("suffixcache");
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("ResultSet closed") || e.getMessage().contains("empty result set")) break block8;
                    throw e;
                }
            }
            r.close();
            statement.close();
            this.method.close(conn);
            if (name == null) {
                name = "-Unknown";
            }
            if (uuidraw == null) {
                return new StatEntry(position, board, "", this.pl.getAConfig().getString("no-data-name"), null, "", 0.0);
            }
            return new StatEntry(position, board, prefix, name, UUID.fromString(uuidraw), suffix, value);
        }
        catch (SQLException e) {
            this.pl.getLogger().severe("Unable to get stat of player:");
            e.printStackTrace();
            return new StatEntry(position, board, "", "An error occured", null, "", 0.0);
        }
    }

    public StatEntry getStatEntry(OfflinePlayer player, String board) {
        StatEntry r = null;
        for (int i = 1; i < 10000000 && r == null; ++i) {
            StatEntry rt = this.getStat(i, board);
            if (rt.getPlayerID() != null && !player.getUniqueId().equals(rt.getPlayerID())) continue;
            r = rt;
        }
        return r;
    }

    public boolean createBoard(String name) {
        try {
            Connection conn = this.method.getConnection();
            Statement statement = conn.createStatement();
            if (this.method instanceof SqliteMethod) {
                statement.executeUpdate("create table if not exists `" + this.tablePrefix + name + "` (id TEXT PRIMARY KEY, value NUMERIC, namecache TEXT, prefixcache TEXT, suffixcache TEXT)");
            } else {
                statement.executeUpdate("create table if not exists \n`" + this.tablePrefix + name + "`\n (\nid VARCHAR(36) PRIMARY KEY,\n value BIGINT,\n namecache VARCHAR(16),\n prefixcache TINYTEXT, suffixcache TINYTEXT)");
            }
            statement.close();
            this.method.close(conn);
            return true;
        }
        catch (SQLException e) {
            this.pl.getLogger().severe("Unable to create board:");
            e.printStackTrace();
            return false;
        }
    }

    public void removePlayer(String board, UUID player) {
        try {
            Connection conn = this.method.getConnection();
            conn.createStatement().executeUpdate("delete from `" + this.tablePrefix + board + "` where id=`" + player + "`");
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.pl.getLogger().severe("Unable to remove player from board:");
            e.printStackTrace();
        }
    }

    public boolean boardExists(String board) {
        return this.getBoards().contains(board);
    }

    public List<String> getBoards() {
        ArrayList<String> o = new ArrayList<String>();
        try {
            Connection conn = this.method.getConnection();
            Statement statement = conn.createStatement();
            ResultSet r = this.method instanceof SqliteMethod ? statement.executeQuery("SELECT \n    name\nFROM \n    sqlite_master \nWHERE \n    type ='table' AND \n    name NOT LIKE 'sqlite_%';") : statement.executeQuery("show tables;");
            while (r.next()) {
                String b = r.getString(1);
                if (b.indexOf(this.tablePrefix) != 0) continue;
                o.add(b.substring(this.tablePrefix.length()));
            }
            statement.close();
            r.close();
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.pl.getLogger().severe("Unable to get list of tables:");
            e.printStackTrace();
        }
        return o;
    }

    public boolean removeBoard(String board) {
        if (!this.getBoards().contains(board)) {
            return true;
        }
        try {
            Connection conn = this.method.getConnection();
            Statement statement = conn.createStatement();
            statement.executeUpdate("drop table `" + this.tablePrefix + board + "`;");
            statement.close();
            this.method.close(conn);
            return true;
        }
        catch (SQLException e) {
            this.pl.getLogger().warning("An error occurred while trying to remove a board:");
            e.printStackTrace();
            return false;
        }
    }

    public void updatePlayerStats(OfflinePlayer player) {
        for (String b : this.getBoards()) {
            this.updateStat(b, player);
        }
    }

    public void updateStat(String board, OfflinePlayer player) {
        double output;
        try {
            String outputraw = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + Cache.alternatePlaceholders(board) + "%")).replaceAll(",", "");
            output = Double.parseDouble(outputraw);
        }
        catch (NumberFormatException e) {
            return;
        }
        catch (Exception e) {
            this.pl.getLogger().warning("Placeholder %" + board + "% for player " + player.getName() + " threw an error:");
            e.printStackTrace();
            return;
        }
        Debug.info("Placeholder " + board + " for " + player.getName() + " returned " + output);
        String prefix = "";
        String suffix = "";
        if (this.pl.hasVault() && player instanceof Player) {
            prefix = this.pl.getVaultChat().getPlayerPrefix((Player)player);
            suffix = this.pl.getVaultChat().getPlayerSuffix((Player)player);
        }
        Debug.info("Updating " + player.getName() + " on board " + board + " with values v: " + output + " suffix: " + suffix + " prefix: " + prefix);
        try {
            Connection conn = this.method.getConnection();
            try (PreparedStatement statement = conn.prepareStatement("insert into `" + this.tablePrefix + board + "` (id, value, namecache, prefixcache, suffixcache) values (?, ?, ?, ?, ?)");){
                Debug.info("in try");
                statement.setString(1, player.getUniqueId().toString());
                statement.setDouble(2, output);
                statement.setString(3, player.getName());
                statement.setString(4, prefix);
                statement.setString(5, suffix);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                Debug.info("in catch");
                try (PreparedStatement statement2 = conn.prepareStatement("update `" + this.tablePrefix + board + "` set value=" + output + ", namecache=?, prefixcache=?, suffixcache=? where id=?");){
                    statement2.setString(2, prefix);
                    statement2.setString(3, suffix);
                    statement2.setString(1, player.getName());
                    statement2.setString(4, player.getUniqueId().toString());
                    statement2.executeUpdate();
                }
            }
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.pl.getLogger().severe("Unable to update stat for player:");
            e.printStackTrace();
        }
    }

    public static String alternatePlaceholders(String board) {
        if (!altPlaceholders.containsKey(board)) {
            return board;
        }
        return altPlaceholders.get(board);
    }

    static {
        altPlaceholders = new HashMap<String, String>(){
            {
                this.put("ajpk_stats_highscore", "ajpk_stats_highscore_nocache");
                this.put("ajtr_stats_wins", "ajtr_stats_wins_nocache");
                this.put("ajtr_stats_losses", "ajtr_stats_losses_nocache");
                this.put("ajtr_stats_gamesplayed", "ajtr_stats_gamesplayer_nocache");
            }
        };
    }
}

