/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache.methods;

import java.sql.Connection;
import java.sql.SQLException;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.cache.CacheMethod;
import us.ajg0702.leaderboards.libs.hikari.HikariConfig;
import us.ajg0702.leaderboards.libs.hikari.HikariDataSource;
import us.ajg0702.leaderboards.libs.spigot.ConfigFile;

public class MysqlMethod
implements CacheMethod {
    private final HikariConfig hikariConfig = new HikariConfig();
    private HikariDataSource ds;

    @Override
    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            return null;
        }
        return this.ds.getConnection();
    }

    @Override
    public void init(Main plugin, ConfigFile config, Cache cacheInstance) {
        String ip = config.getString("ip");
        String username = config.getString("username");
        String password = config.getString("password");
        String database = config.getString("database");
        boolean useSSL = config.getBoolean("useSSL");
        boolean allowPublicKeyRetrieval = config.getBoolean("allowPublicKeyRetrieval");
        int minCount = config.getInt("minConnections");
        int maxCount = config.getInt("maxConnections");
        String url = "jdbc:mysql://" + ip + "/" + database + "?useSSL=" + useSSL + "&allowPublicKeyRetrieval=" + allowPublicKeyRetrieval + "&characterEncoding=utf8";
        this.hikariConfig.setDriverClassName("com.mysql.jdbc.Driver");
        this.hikariConfig.setJdbcUrl(url);
        this.hikariConfig.setUsername(username);
        this.hikariConfig.setPassword(password);
        this.hikariConfig.setMaximumPoolSize(maxCount);
        this.hikariConfig.setMinimumIdle(minCount);
        this.ds = new HikariDataSource(this.hikariConfig);
        this.ds.setLeakDetectionThreshold(60000L);
    }

    @Override
    public void close(Connection connection) throws SQLException {
        connection.close();
    }
}

