/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.heads;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.heads.HeadUtils;
import us.ajg0702.leaderboards.libs.spigot.VersionSupport;
import us.ajg0702.leaderboards.signs.BoardSign;

public class HeadManager {
    static HeadManager instance;
    Main pl;

    public static HeadManager getInstance() {
        return instance;
    }

    public static HeadManager getInstance(Main pl) {
        if (instance == null) {
            instance = new HeadManager(pl);
        }
        return instance;
    }

    private HeadManager(Main pl) {
        this.pl = pl;
    }

    public void search(BoardSign sign, String name, UUID id) {
        BlockFace face;
        if (!sign.getLocation().getBlock().getType().toString().contains("SIGN")) {
            return;
        }
        if (!Cache.getInstance().boardExists(sign.getBoard())) {
            return;
        }
        if (id == null) {
            return;
        }
        Sign ss = sign.getSign();
        if (VersionSupport.getMinorVersion() > 12) {
            org.bukkit.block.data.type.Sign bs;
            BlockData bd = ss.getBlockData();
            if (bd instanceof org.bukkit.block.data.type.Sign) {
                bs = (org.bukkit.block.data.type.Sign)bd;
                face = bs.getRotation();
            } else {
                bs = (WallSign)bd;
                face = bs.getFacing();
            }
        } else {
            org.bukkit.material.Sign bs = (org.bukkit.material.Sign)ss.getData();
            face = bs.getFacing();
        }
        Location sl = sign.getLocation();
        switch (face) {
            case NORTH: 
            case NORTH_EAST: 
            case NORTH_NORTH_EAST: 
            case NORTH_NORTH_WEST: 
            case NORTH_WEST: {
                for (int z = sl.getBlockZ() + 1; z > sl.getBlockZ() - 1; --z) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                        this.debugParticles(curloc);
                        this.checkHead(curloc, name, id);
                        this.checkArmorstand(curloc, name, id);
                    }
                }
                break;
            }
            case SOUTH: 
            case SOUTH_EAST: 
            case SOUTH_SOUTH_EAST: 
            case SOUTH_SOUTH_WEST: 
            case SOUTH_WEST: {
                for (int z = sl.getBlockZ(); z > sl.getBlockZ() - 2; --z) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                        this.debugParticles(curloc);
                        this.checkHead(curloc, name, id);
                        this.checkArmorstand(curloc, name, id);
                    }
                }
                break;
            }
            case EAST: 
            case EAST_NORTH_EAST: 
            case EAST_SOUTH_EAST: {
                for (int x = sl.getBlockX(); x > sl.getBlockX() - 2; --x) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                        this.debugParticles(curloc);
                        this.checkHead(curloc, name, id);
                        this.checkArmorstand(curloc, name, id);
                    }
                }
                break;
            }
            case WEST: 
            case WEST_NORTH_WEST: 
            case WEST_SOUTH_WEST: {
                for (int x = sl.getBlockX() + 1; x > sl.getBlockX() - 1; --x) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                        this.debugParticles(curloc);
                        this.checkHead(curloc, name, id);
                        this.checkArmorstand(curloc, name, id);
                    }
                }
                break;
            }
        }
    }

    private void setArmorstandHead(ArmorStand stand, String name, UUID id) {
        if (VersionSupport.getMinorVersion() >= 10) {
            stand.setSilent(true);
        }
        ItemStack item = HeadUtils.getInstance().getHeadItem(name);
        stand.setHelmet(item);
    }

    private void debugParticles(Location curloc) {
    }

    private void checkHead(final Location loc, final String name, final UUID id) {
        Validate.notNull((Object)loc);
        Validate.notNull((Object)id, (String)"UUID is null!");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.pl, () -> {
            final OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)id);
            Bukkit.getScheduler().runTask((Plugin)this.pl, new Runnable(){

                @Override
                public void run() {
                    BlockState bs = loc.getBlock().getState();
                    if (!(bs instanceof Skull)) {
                        return;
                    }
                    if (HeadUtils.getInstance().getHeadValue(name).equals("")) {
                        return;
                    }
                    Skull skull = (Skull)bs;
                    boolean update = false;
                    if (VersionSupport.getMinorVersion() > 9) {
                        if (skull.hasOwner()) {
                            if (Objects.equals(skull.getOwningPlayer().getUniqueId(), id)) {
                                skull.setOwningPlayer(op);
                                update = true;
                            }
                        } else {
                            skull.setOwningPlayer(op);
                            update = true;
                        }
                    } else if (!Objects.equals(skull.getOwner(), name)) {
                        skull.setOwner(name);
                        update = true;
                    }
                    if (update) {
                        skull.update();
                    }
                }
            });
        });
    }

    private void checkArmorstand(final Location curloc, final String name, final UUID id) {
        final Collection entities = curloc.getWorld().getNearbyEntities(curloc, 1.0, 1.0, 1.0);
        if (entities.size() > 0) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.pl, new Runnable(){

                @Override
                public void run() {
                    for (Entity entity : entities) {
                        Location eloc;
                        if (!(entity instanceof ArmorStand) || (eloc = entity.getLocation()).getBlockX() != curloc.getBlockX() || eloc.getBlockZ() != curloc.getBlockZ()) continue;
                        HeadManager.this.setArmorstandHead((ArmorStand)entity, name, id);
                    }
                }
            });
        }
    }
}

