/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.heads;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import us.ajg0702.leaderboards.Utils.CachedData;
import us.ajg0702.leaderboards.libs.spigot.VersionSupport;

public class HeadUtils {
    static HeadUtils instance;
    Map<String, CachedData<String>> skinCache = new HashMap<String, CachedData<String>>();
    long lastClear = System.currentTimeMillis();
    HashMap<String, String> urlCache = new HashMap();
    HashMap<String, Long> urlLastget = new HashMap();

    public static HeadUtils getInstance() {
        if (instance == null) {
            instance = new HeadUtils();
        }
        return instance;
    }

    public ItemStack getHeadItem(String name) {
        ItemStack skull = null;
        if (VersionSupport.getMinorVersion() <= 12) {
            skull = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        } else if (VersionSupport.getMinorVersion() > 12) {
            skull = new ItemStack(Material.PLAYER_HEAD, 1);
        }
        String value = this.getHeadValue(name);
        if (value.equals("")) {
            return skull;
        }
        UUID hashAsId = new UUID(value.hashCode(), value.hashCode());
        return Bukkit.getUnsafe().modifyItemStack(skull, "{SkullOwner:{Id:\"" + hashAsId + "\",Properties:{textures:[{Value:\"" + value + "\"}]}}}");
    }

    public String getHeadValue(String name) {
        if ((double)(System.currentTimeMillis() - this.lastClear) > 5400000.0) {
            this.skinCache = new HashMap<String, CachedData<String>>();
        }
        if (this.skinCache.containsKey(name) && (double)this.skinCache.get(name).getTimeSince() < 300000.0) {
            return this.skinCache.get(name).getData();
        }
        Gson g = new Gson();
        String result = this.getURLContent("https://api.mojang.com/users/profiles/minecraft/" + name);
        JsonObject jObj = (JsonObject)g.fromJson(result, JsonObject.class);
        if (jObj == null || jObj.get("id") == null) {
            return "";
        }
        String uuid = jObj.get("id").toString().replace("\"", "");
        String signature = this.getURLContent("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
        jObj = (JsonObject)g.fromJson(signature, JsonObject.class);
        if (jObj == null || jObj.get("id") == null) {
            return "";
        }
        String value = jObj.getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
        String decoded = new String(Base64.getDecoder().decode(value));
        jObj = (JsonObject)g.fromJson(decoded, JsonObject.class);
        String skin = jObj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
        byte[] skinByte = ("{\"textures\":{\"SKIN\":{\"url\":\"" + skin + "\"}}}").getBytes();
        String finalSkin = new String(Base64.getEncoder().encode(skinByte));
        this.skinCache.put(name, new CachedData<String>(finalSkin));
        return finalSkin;
    }

    public static GameProfile getNonPlayerProfile(String skinURL) {
        GameProfile newSkinProfile = new GameProfile(UUID.randomUUID(), null);
        newSkinProfile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + skinURL + "\"}}}"))));
        return newSkinProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURLContent(String urlStr) {
        if (this.urlLastget.containsKey(urlStr) && (double)(System.currentTimeMillis() - this.urlLastget.get(urlStr)) < 300000.0) {
            return this.urlCache.get(urlStr);
        }
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            URL url = new URL(urlStr);
            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception str) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException str) {}
        }
        String r = sb.toString();
        this.urlCache.put(urlStr, r);
        this.urlLastget.put(urlStr, System.currentTimeMillis());
        return r;
    }
}

