/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.bungee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeConfig {
    File f;
    Configuration config;
    ConfigurationProvider cv = ConfigurationProvider.getProvider(YamlConfiguration.class);
    String nfm = "Could not find KEY in config! Try restarting the server or deleting the config and allowing the plugin to re-create it.";
    Plugin pl;

    public Object get(String key) {
        Object r = this.config.get(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public Double getDouble(String key) {
        Double r = this.config.getDouble(key, 28374.234823498);
        if (r == 28374.234823498) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public Integer getInt(String key) {
        int r = this.config.getInt(key, -38964298);
        if (r == -38964298) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public String getString(String key) {
        String r = this.config.getString(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public List<String> getStringList(String key) {
        List r = this.config.getStringList(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public boolean getBoolean(String key) {
        return this.config.getBoolean(key);
    }

    public String getDefaultConfig() throws IOException {
        String line;
        BufferedReader stream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/config.yml")));
        StringBuilder configfile = new StringBuilder();
        while ((line = stream.readLine()) != null) {
            configfile.append(line + "\n");
        }
        return configfile.toString();
    }

    public String getConfigString() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.pl.getDataFolder().getPath().toString(), "config.yml"));
        String end = "";
        for (String line : lines) {
            end = end + line + "\n";
        }
        return end;
    }

    public BungeeConfig(Plugin plugin) {
        this.pl = plugin;
        this.f = new File(plugin.getDataFolder(), "config.yml");
        if (!this.f.exists()) {
            if (!Files.exists(this.pl.getDataFolder().toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(this.pl.getDataFolder().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                String[] lines;
                PrintWriter writer = new PrintWriter(this.pl.getDataFolder() + File.separator + "config.yml", "UTF-8");
                for (String line : lines = this.getDefaultConfig().split("\n")) {
                    writer.println(line);
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.f = new File(this.pl.getDataFolder(), "config.yml");
                Configuration oldconfig = this.cv.load(this.f);
                String newConfig = this.getDefaultConfig();
                int oldver = oldconfig.getInt("config-version", 0);
                String strv = newConfig.split("config\\-version: ")[1].split("\n")[0];
                int newver = Integer.parseInt(strv);
                if (oldver < newver) {
                    String[] lines;
                    this.pl.getLogger().info("Starting config converter!");
                    Date date = Calendar.getInstance().getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd-hh-mm-ss");
                    String strDate = dateFormat.format(date);
                    BungeeConfig.duplicateFile(this.f, new File(this.pl.getDataFolder(), "config.yml.old." + strDate));
                    String oldConfig = this.getConfigString();
                    this.f = new File(this.pl.getDataFolder(), "config.yml");
                    this.config = this.cv.load(this.f);
                    for (String key : oldconfig.getKeys()) {
                        this.pl.getLogger().info("Key: " + key);
                        String[] keyParts = key.split("\\.");
                        String keySec = keyParts[keyParts.length - 1];
                        this.pl.getLogger().info("keySec: " + keySec);
                        String newVal = newConfig.split(keySec)[1].split("\n")[0];
                        int i = 0;
                        for (String l : newConfig.split(keySec)[1].split("\n")) {
                            if (i == 0) {
                                ++i;
                                continue;
                            }
                            ++i;
                            this.pl.getLogger().info("Scanning: " + l);
                            if (!l.startsWith("-")) break;
                            newVal = newVal + "\n" + l;
                        }
                        String find = keySec + newVal;
                        String replace = keySec + ": " + oldconfig.get(key);
                        replace = replace.replaceAll("\\[", "\n- ");
                        replace = replace.replaceAll("\\, ", "\n- ");
                        replace = replace.replaceAll("\\]", "");
                        this.pl.getLogger().info("Find: " + find + " Replace w: " + replace);
                        if (keySec.equals("config-version")) continue;
                        newConfig = newConfig.replaceAll(find, replace);
                    }
                    PrintWriter writer = new PrintWriter(this.f, "UTF-8");
                    for (String line : lines = newConfig.split("\n")) {
                        writer.println(line);
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                this.pl.getLogger().severe("Unable to load default config! " + e.getMessage() + "\n" + e.getStackTrace().toString());
            }
        }
        this.f = new File(this.pl.getDataFolder(), "config.yml");
        try {
            this.config = this.cv.load(this.f);
        }
        catch (IOException e) {
            this.pl.getLogger().warning("Unable to reload the config:");
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.config = this.cv.load(this.f);
        }
        catch (IOException e) {
            this.pl.getLogger().warning("Unable to reload the config:");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void duplicateFile(File source, File destination) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }
}

