/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.spigot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigFile {
    File f;
    YamlConfiguration config;
    String nfm;
    JavaPlugin pl;
    String filename;

    public Object get(String key) {
        Object r = this.config.get(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public Integer getInt(String key) {
        int r = this.config.getInt(key, -38964298);
        if (r == -38964298) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public String getString(String key) {
        String r = this.config.getString(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public List<String> getStringList(String key) {
        List r = this.config.getStringList(key);
        if (r == null) {
            this.pl.getLogger().severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    public boolean getBoolean(String key) {
        return this.config.getBoolean(key);
    }

    public String getDefaultConfig() throws IOException {
        String line;
        BufferedReader stream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/" + this.filename)));
        StringBuilder configfile = new StringBuilder();
        while ((line = stream.readLine()) != null) {
            configfile.append(line + "\n");
        }
        return configfile.toString();
    }

    public String getConfigString() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.pl.getDataFolder().getPath().toString(), this.filename));
        String end = "";
        for (String line : lines) {
            end = end + line + "\n";
        }
        return end;
    }

    public ConfigFile(JavaPlugin plugin, String fileName) {
        this.filename = fileName;
        this.nfm = "Could not find KEY in " + fileName + "! Try restarting the server or deleting the config and allowing the plugin to re-create it.";
        this.pl = plugin;
        this.f = new File(plugin.getDataFolder(), fileName);
        if (!this.f.exists()) {
            if (!Files.exists(this.pl.getDataFolder().toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(this.pl.getDataFolder().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                String[] lines;
                PrintWriter writer = new PrintWriter(this.pl.getDataFolder() + File.separator + fileName, "UTF-8");
                for (String line : lines = this.getDefaultConfig().split("\n")) {
                    writer.println(line);
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.f = new File(this.pl.getDataFolder(), fileName);
                YamlConfiguration oldconfig = YamlConfiguration.loadConfiguration((File)this.f);
                String newConfig = this.getDefaultConfig();
                int oldver = oldconfig.getInt("config-version", 0);
                String strv = newConfig.split("config\\-version: ")[1].split("\n")[0];
                int newver = Integer.parseInt(strv);
                if (oldver < newver) {
                    String[] lines;
                    this.pl.getLogger().info("Starting config converter!");
                    Date date = Calendar.getInstance().getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd-hh-mm-ss");
                    String strDate = dateFormat.format(date);
                    ConfigFile.duplicateFile(this.f, new File(this.pl.getDataFolder(), fileName + ".old." + strDate));
                    String oldConfig = this.getConfigString();
                    this.f = new File(this.pl.getDataFolder(), fileName);
                    this.config = YamlConfiguration.loadConfiguration((File)this.f);
                    for (String key : oldconfig.getKeys(true)) {
                        this.pl.getLogger().info("Key: " + key);
                        String[] keyParts = key.split("\\.");
                        String keySec = keyParts[keyParts.length - 1];
                        this.pl.getLogger().info("keySec: " + keySec);
                        String newVal = newConfig.split(keySec)[1].split("\n")[0];
                        int i = 0;
                        for (String l : newConfig.split(keySec)[1].split("\n")) {
                            if (i == 0) {
                                ++i;
                                continue;
                            }
                            ++i;
                            this.pl.getLogger().info("Scanning: " + l);
                            if (!l.startsWith("-")) break;
                            newVal = newVal + "\n" + l;
                        }
                        String find = keySec + newVal;
                        String replace = keySec + ": " + oldconfig.get(key);
                        replace = replace.replaceAll("\\[", "\n- ");
                        replace = replace.replaceAll("\\, ", "\n- ");
                        replace = replace.replaceAll("\\]", "");
                        this.pl.getLogger().info("Find: " + find + " Replace w: " + replace);
                        if (keySec.equals("config-version")) continue;
                        newConfig = newConfig.replaceAll("\\Q" + find + "\\E", replace);
                    }
                    PrintWriter writer = new PrintWriter(this.f, "UTF-8");
                    for (String line : lines = newConfig.split("\n")) {
                        writer.println(line);
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("Unable to load default config! " + e.getMessage() + "\n" + e.getStackTrace().toString());
            }
        }
        this.f = new File(this.pl.getDataFolder(), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void duplicateFile(File source, File destination) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }
}

