/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.spigot;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Messages {
    static Messages INSTANCE = null;
    JavaPlugin pl;
    YamlConfiguration msgs;
    File msgFile;
    LinkedHashMap<String, String> defaultValues;

    public static Messages getInstance() {
        return INSTANCE;
    }

    public static Messages getInstance(JavaPlugin pl, LinkedHashMap<String, String> defaultValues) {
        if (INSTANCE == null) {
            INSTANCE = new Messages(pl, defaultValues);
        }
        return INSTANCE;
    }

    private Messages(JavaPlugin pl, LinkedHashMap<String, String> defaultValues) {
        this.pl = pl;
        this.defaultValues = defaultValues;
        this.loadMessagesFile(defaultValues);
    }

    private void loadMessagesFile(LinkedHashMap<String, String> d) {
        this.msgFile = new File(this.pl.getDataFolder(), "messages.yml");
        if (!this.msgFile.exists()) {
            try {
                this.pl.getDataFolder().mkdirs();
                this.msgFile.createNewFile();
            }
            catch (IOException e) {
                this.pl.getLogger().severe("Unable to create messages file:");
                e.printStackTrace();
            }
        }
        this.msgs = YamlConfiguration.loadConfiguration((File)this.msgFile);
        for (String k : d.keySet()) {
            if (this.msgs.contains(k)) continue;
            this.msgs.set(k, (Object)d.get(k));
        }
        try {
            this.msgs.save(this.msgFile);
        }
        catch (IOException e) {
            this.pl.getLogger().severe("Unable to save messages file:");
            e.printStackTrace();
        }
    }

    public String get(String key) {
        String msg = this.msgs.getString(key, "&cMessage '" + key + "' does not exist!");
        msg = this.color(msg);
        return msg;
    }

    public String get(String key, String ... placeholders) {
        String msg = this.get(key);
        for (String sr : placeholders) {
            String placeholder = sr.split(":")[0];
            String value = sr.replaceFirst(Matcher.quoteReplacement(placeholder + ":"), "");
            msg = msg.replaceAll("\\{" + Matcher.quoteReplacement(placeholder) + "\\}", value);
        }
        return msg;
    }

    public String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg).replaceAll(Matcher.quoteReplacement("\\n"), "\n");
    }

    public void reload() {
        this.loadMessagesFile(this.defaultValues);
    }
}

