/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.signs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Main;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TopManager;
import us.ajg0702.leaderboards.heads.HeadManager;
import us.ajg0702.leaderboards.libs.spigot.Messages;
import us.ajg0702.leaderboards.signs.BoardSign;

public class SignManager {
    static SignManager instance;
    Main pl;
    public YamlConfiguration cfg;
    File cfgFile;
    Messages msgs;
    List<BoardSign> signs = new ArrayList<BoardSign>();
    HashMap<String, String> names = new HashMap();

    public static SignManager getInstance() {
        return instance;
    }

    public static SignManager getInstance(Main pl) {
        if (instance == null) {
            instance = new SignManager(pl);
        }
        return instance;
    }

    private SignManager(Main pl) {
        this.pl = pl;
        this.msgs = Messages.getInstance();
        Bukkit.getScheduler().runTaskLater((Plugin)pl, this::reload, 1L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)pl, this::updateSigns, 200L, 20L);
    }

    public void reload() {
        this.cfgFile = new File(this.pl.getDataFolder(), "displays.yml");
        this.cfg = YamlConfiguration.loadConfiguration((File)this.cfgFile);
        this.cfg.options().header("This file is for storing sign location, npcs, and other things in the plugin that might display data");
        this.signs.clear();
        if (this.cfg.contains("signs")) {
            List rawsigns = this.cfg.getStringList("signs");
            for (String s : rawsigns) {
                try {
                    this.signs.add(BoardSign.deserialize(s));
                }
                catch (Exception e) {
                    this.pl.getLogger().warning("An error occurred while loading a sign:");
                    e.printStackTrace();
                }
            }
        }
        this.updateNameCache();
    }

    public List<BoardSign> getSigns() {
        return this.signs;
    }

    public boolean removeSign(Location l) {
        boolean save = false;
        Iterator<BoardSign> i = this.signs.iterator();
        while (i.hasNext()) {
            BoardSign s = i.next();
            if (!l.equals((Object)s.getLocation())) continue;
            i.remove();
            save = true;
            s.setText("", "", "", "");
            break;
        }
        if (save) {
            this.saveFile();
        }
        return save;
    }

    public BoardSign findSign(Location l) {
        for (BoardSign s : this.signs) {
            if (!l.equals((Object)s.getLocation())) continue;
            return s;
        }
        return null;
    }

    public void addSign(Location loc, String board, int pos) {
        if (this.findSign(loc) != null) {
            return;
        }
        this.signs.add(new BoardSign(loc, board, pos));
        this.saveFile();
    }

    public void saveFile() {
        ArrayList<String> signsraw = new ArrayList<String>();
        for (BoardSign sign : this.signs) {
            signsraw.add(sign.serialize());
        }
        this.cfg.set("signs", signsraw);
        try {
            this.cfg.save(this.cfgFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateSigns() {
        this.updateNameCache();
        for (BoardSign sign : this.signs) {
            this.updateSign(sign);
        }
    }

    public void updateNameCache() {
        List<String> namesraw = this.pl.getAConfig().getStringList("value-names");
        for (String s : namesraw) {
            if (!s.contains("%")) continue;
            String[] parts = s.split("%");
            this.names.put(parts[0], parts[1]);
        }
    }

    public void updateSign(BoardSign sign) {
        if (!this.isSignChunkLoaded(sign)) {
            return;
        }
        String name = "";
        if (this.names.containsKey(sign.getBoard())) {
            name = this.names.get(sign.getBoard());
        }
        StatEntry r = TopManager.getInstance().getStat(sign.getPosition(), sign.getBoard());
        List<String> lines = Arrays.asList(this.msgs.get("signs.top.1"), this.msgs.get("signs.top.2"), this.msgs.get("signs.top.3"), this.msgs.get("signs.top.4"));
        ArrayList<String> plines = new ArrayList<String>();
        for (String l : lines) {
            String pline = l.replaceAll("\\{POSITION}", sign.getPosition() + "").replaceAll("\\{NAME}", r.getPlayer()).replaceAll("\\{VALUE}", r.getScorePretty()).replaceAll("\\{VALUENAME}", name);
            plines.add(pline);
        }
        Bukkit.getScheduler().runTask((Plugin)this.pl, () -> {
            if (!r.getPlayer().equals(this.pl.getAConfig().getString("no-data-name")) && r.getPlayerID() != null) {
                HeadManager.getInstance().search(sign, r.getPlayer(), r.getPlayerID());
            }
            sign.setText((String)plines.get(0), (String)plines.get(1), (String)plines.get(2), (String)plines.get(3));
        });
    }

    public boolean isSignChunkLoaded(BoardSign sign) {
        return sign.getWorld().isChunkLoaded(sign.getX(), sign.getZ());
    }
}

