/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.filoghost.chestcommands.DefaultBackendAPI;
import me.filoghost.chestcommands.api.internal.BackendAPI;
import me.filoghost.chestcommands.command.CommandHandler;
import me.filoghost.chestcommands.config.ConfigManager;
import me.filoghost.chestcommands.config.CustomPlaceholders;
import me.filoghost.chestcommands.config.Settings;
import me.filoghost.chestcommands.fcommons.BaseJavaPlugin;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.fcommons.logging.Log;
import me.filoghost.chestcommands.fcommons.reflection.ReflectionUtils;
import me.filoghost.chestcommands.hook.BarAPIHook;
import me.filoghost.chestcommands.hook.BungeeCordHook;
import me.filoghost.chestcommands.hook.PlaceholderAPIHook;
import me.filoghost.chestcommands.hook.VaultEconomyHook;
import me.filoghost.chestcommands.legacy.UpgradeExecutorException;
import me.filoghost.chestcommands.legacy.UpgradesExecutor;
import me.filoghost.chestcommands.listener.CommandListener;
import me.filoghost.chestcommands.listener.InventoryListener;
import me.filoghost.chestcommands.listener.JoinListener;
import me.filoghost.chestcommands.listener.SignListener;
import me.filoghost.chestcommands.logging.PrintableErrorCollector;
import me.filoghost.chestcommands.menu.MenuManager;
import me.filoghost.chestcommands.metrics.MetricsLite;
import me.filoghost.chestcommands.parsing.menu.LoadedMenu;
import me.filoghost.chestcommands.placeholder.PlaceholderManager;
import me.filoghost.chestcommands.task.TickingTask;
import me.filoghost.chestcommands.updater.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChestCommands
extends BaseJavaPlugin {
    public static final String CHAT_PREFIX = ChatColor.DARK_GREEN + "[" + ChatColor.GREEN + "ChestCommands" + ChatColor.DARK_GREEN + "] " + ChatColor.GREEN;
    private static Plugin pluginInstance;
    private static Path dataFolderPath;
    private static ConfigManager configManager;
    private static CustomPlaceholders placeholders;
    private static ErrorCollector lastLoadErrors;
    private static String newVersion;

    @Override
    protected void onCheckedEnable() throws BaseJavaPlugin.PluginEnableException {
        if (!ReflectionUtils.isClassLoaded("org.bukkit.inventory.ItemFlag")) {
            if (Bukkit.getVersion().contains("(MC: 1.8)")) {
                throw new BaseJavaPlugin.PluginEnableException("ChestCommands requires a more recent version of Bukkit 1.8 to run.");
            }
            throw new BaseJavaPlugin.PluginEnableException("ChestCommands requires at least Bukkit 1.8 to run.");
        }
        if (pluginInstance != null || System.getProperty("ChestCommandsLoaded") != null) {
            Log.warning("Please do not use /reload or plugin reloaders. Use the command \"/cc reload\" instead.");
            return;
        }
        System.setProperty("ChestCommandsLoaded", "true");
        pluginInstance = this;
        dataFolderPath = this.getDataFolder().toPath();
        Log.setLogger(this.getLogger());
        configManager = new ConfigManager(ChestCommands.getDataFolderPath());
        placeholders = new CustomPlaceholders();
        BackendAPI.setImplementation(new DefaultBackendAPI());
        VaultEconomyHook.INSTANCE.setup();
        BarAPIHook.INSTANCE.setup();
        PlaceholderAPIHook.INSTANCE.setup();
        BungeeCordHook.INSTANCE.setup();
        if (VaultEconomyHook.INSTANCE.isEnabled()) {
            Log.info("Hooked Vault");
        } else {
            Log.warning("Couldn't find Vault and a compatible economy plugin! Money-related features will not work.");
        }
        if (BarAPIHook.INSTANCE.isEnabled()) {
            Log.info("Hooked BarAPI");
        }
        if (PlaceholderAPIHook.INSTANCE.isEnabled()) {
            Log.info("Hooked PlaceholderAPI");
        }
        if (Settings.update_notifications) {
            UpdateChecker.run((Plugin)this, 56919, newVersion -> {
                ChestCommands.newVersion = newVersion;
                Log.info("Found a new version: " + newVersion + " (yours: v" + this.getDescription().getVersion() + ")");
                Log.info("Download the update on Bukkit Dev:");
                Log.info("https://dev.bukkit.org/projects/chest-commands");
            });
        }
        int pluginID = 3658;
        new MetricsLite((Plugin)this, pluginID);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SignListener(), (Plugin)this);
        new CommandHandler("chestcommands").register(this);
        ErrorCollector errorCollector = ChestCommands.load();
        if (errorCollector.hasErrors()) {
            errorCollector.logToConsole();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> Bukkit.getConsoleSender().sendMessage(CHAT_PREFIX + ChatColor.RED + "Encountered " + errorCollector.getErrorsCount() + " error(s) on load. Check previous console logs or run \"/chestcommands errors\" to see them again."), 10L);
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)new TickingTask(), 1L, 1L);
    }

    public void onDisable() {
        MenuManager.closeAllOpenMenuViews();
    }

    public static ErrorCollector load() {
        PrintableErrorCollector errorCollector = new PrintableErrorCollector();
        MenuManager.reset();
        boolean isFreshInstall = !Files.isDirectory(configManager.getRootDataFolder(), new LinkOption[0]);
        try {
            Files.createDirectories(configManager.getRootDataFolder(), new FileAttribute[0]);
        }
        catch (IOException e) {
            errorCollector.add(e, "plugin failed to load, couldn't create data folder");
            return errorCollector;
        }
        UpgradesExecutor upgradeExecutor = new UpgradesExecutor(configManager);
        try {
            boolean allUpgradesSuccessful = upgradeExecutor.run(isFreshInstall, errorCollector);
            if (!allUpgradesSuccessful) {
                errorCollector.add("note: one or more automatic upgrades may have not been applied, configuration files or menus may require manual changes");
            }
        }
        catch (UpgradeExecutorException e) {
            errorCollector.add(e, "error while running automatic configuration upgrades");
            errorCollector.add("note: one or more automatic upgrades may have not been applied, configuration files or menus may require manual changes");
        }
        configManager.tryLoadSettings(errorCollector);
        configManager.tryLoadLang(errorCollector);
        placeholders = configManager.tryLoadCustomPlaceholders(errorCollector);
        PlaceholderManager.setStaticPlaceholders(placeholders.getPlaceholders());
        if (!Files.isDirectory(configManager.getMenusFolder(), new LinkOption[0])) {
            ConfigLoader exampleMenuLoader = configManager.getConfigLoader(configManager.getMenusFolder().resolve("example.yml"));
            configManager.tryCreateDefault(errorCollector, exampleMenuLoader);
        }
        List<LoadedMenu> loadedMenus = configManager.tryLoadMenus(errorCollector);
        for (LoadedMenu loadedMenu : loadedMenus) {
            MenuManager.registerMenu(loadedMenu, errorCollector);
        }
        lastLoadErrors = errorCollector;
        return errorCollector;
    }

    public static Plugin getInstance() {
        return pluginInstance;
    }

    public static Path getDataFolderPath() {
        return dataFolderPath;
    }

    public static boolean hasNewVersion() {
        return newVersion != null;
    }

    public static String getNewVersion() {
        return newVersion;
    }

    public static ErrorCollector getLastLoadErrors() {
        return lastLoadErrors;
    }
}

