/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.action;

import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.fcommons.Colors;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.hook.BarAPIHook;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.NumberParser;
import me.filoghost.chestcommands.parsing.ParseException;
import me.filoghost.chestcommands.placeholder.PlaceholderString;
import org.bukkit.entity.Player;

public class DragonBarAction
implements Action {
    private final PlaceholderString message;
    private final int seconds;

    public DragonBarAction(String serialiazedAction) throws ParseException {
        String message;
        String[] split = Strings.trimmedSplit(serialiazedAction, "\\|", 2);
        if (split.length > 1) {
            try {
                this.seconds = NumberParser.getStrictlyPositiveInteger(split[0]);
                message = split[1];
            }
            catch (ParseException e) {
                throw new ParseException(Errors.Parsing.invalidBossBarTime(split[0]), e);
            }
        } else {
            this.seconds = 1;
            message = serialiazedAction;
        }
        this.message = PlaceholderString.of(Colors.addColors(message));
    }

    @Override
    public void execute(Player player) {
        if (BarAPIHook.INSTANCE.isEnabled()) {
            BarAPIHook.setMessage(player, this.message.getValue(player), this.seconds);
        } else {
            player.sendMessage(Errors.User.configurationError("BarAPI plugin not found"));
        }
    }
}

