/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.action;

import java.util.Optional;
import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.collection.Registry;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.NumberParser;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PlaySoundAction
implements Action {
    private static final Registry<Sound> SOUNDS_REGISTRY = Registry.fromEnumValues(Sound.class);
    private final Sound sound;
    private final float pitch;
    private final float volume;

    public PlaySoundAction(String serializedAction) throws ParseException {
        String[] split = Strings.trimmedSplit(serializedAction, ",", 3);
        Optional<Sound> sound = SOUNDS_REGISTRY.find(split[0]);
        if (!sound.isPresent()) {
            throw new ParseException(Errors.Parsing.unknownSound(split[0]));
        }
        this.sound = sound.get();
        if (split.length > 1) {
            try {
                this.pitch = NumberParser.getFloat(split[1]);
            }
            catch (ParseException e) {
                throw new ParseException(Errors.Parsing.invalidSoundPitch(split[1]), e);
            }
        } else {
            this.pitch = 1.0f;
        }
        if (split.length > 2) {
            try {
                this.volume = NumberParser.getFloat(split[2]);
            }
            catch (ParseException e) {
                throw new ParseException(Errors.Parsing.invalidSoundVolume(split[2]), e);
            }
        } else {
            this.volume = 1.0f;
        }
    }

    @Override
    public void execute(Player player) {
        player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
    }
}

