/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.api.internal;

import me.filoghost.chestcommands.api.ConfigurableIcon;
import me.filoghost.chestcommands.api.Menu;
import me.filoghost.chestcommands.api.PlaceholderReplacer;
import me.filoghost.chestcommands.api.StaticIcon;
import me.filoghost.chestcommands.fcommons.Preconditions;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class BackendAPI {
    private static BackendAPI implementation;

    public static void setImplementation(@NotNull BackendAPI implementation) {
        Preconditions.notNull(implementation, "implementation");
        Preconditions.checkState(BackendAPI.implementation == null, "implementation already set");
        BackendAPI.implementation = implementation;
    }

    @NotNull
    public static BackendAPI getImplementation() {
        Preconditions.checkState(implementation != null, "no implementation set");
        return implementation;
    }

    public abstract boolean isInternalMenuLoaded(@NotNull String var1);

    public abstract boolean openInternalMenu(@NotNull Player var1, @NotNull String var2);

    @NotNull
    public abstract Menu createMenu(@NotNull Plugin var1, @NotNull String var2, int var3);

    @NotNull
    public abstract ConfigurableIcon createConfigurableIcon(@NotNull Material var1);

    @NotNull
    public abstract StaticIcon createStaticIcon(@NotNull ItemStack var1);

    public abstract void registerPlaceholder(@NotNull Plugin var1, @NotNull String var2, @NotNull PlaceholderReplacer var3);

    public abstract boolean unregisterPlaceholder(@NotNull Plugin var1, @NotNull String var2);
}

