/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.attribute;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.attribute.AttributeErrorHandler;
import me.filoghost.chestcommands.attribute.IconAttribute;
import me.filoghost.chestcommands.icon.InternalConfigurableIcon;
import me.filoghost.chestcommands.parsing.ItemMetaParser;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.block.banner.Pattern;

public class BannerPatternsAttribute
implements IconAttribute {
    private final List<Pattern> patterns = new ArrayList<Pattern>();

    public BannerPatternsAttribute(List<String> serializedPatterns, AttributeErrorHandler errorHandler) {
        for (String serializedPattern : serializedPatterns) {
            if (serializedPattern == null || serializedPattern.isEmpty()) continue;
            try {
                Pattern pattern = ItemMetaParser.parseBannerPattern(serializedPattern);
                this.patterns.add(pattern);
            }
            catch (ParseException e) {
                errorHandler.onListElementError(serializedPattern, e);
            }
        }
    }

    @Override
    public void apply(InternalConfigurableIcon icon) {
        icon.setBannerPatterns(this.patterns);
    }
}

