/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.attribute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.filoghost.chestcommands.attribute.AttributeErrorHandler;
import me.filoghost.chestcommands.attribute.IconAttribute;
import me.filoghost.chestcommands.icon.InternalConfigurableIcon;
import me.filoghost.chestcommands.parsing.EnchantmentParser;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentsAttribute
implements IconAttribute {
    private final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

    public EnchantmentsAttribute(List<String> serializedEnchantments, AttributeErrorHandler errorHandler) {
        for (String serializedEnchantment : serializedEnchantments) {
            if (serializedEnchantment == null || serializedEnchantment.isEmpty()) continue;
            try {
                EnchantmentParser.EnchantmentDetails enchantment = EnchantmentParser.parseEnchantment(serializedEnchantment);
                this.enchantments.put(enchantment.getEnchantment(), enchantment.getLevel());
            }
            catch (ParseException e) {
                errorHandler.onListElementError(serializedEnchantment, e);
            }
        }
    }

    @Override
    public void apply(InternalConfigurableIcon icon) {
        icon.setEnchantments(this.enchantments);
    }
}

