/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.attribute;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.attribute.AttributeErrorHandler;
import me.filoghost.chestcommands.attribute.IconAttribute;
import me.filoghost.chestcommands.icon.InternalConfigurableIcon;
import me.filoghost.chestcommands.icon.requirement.item.RequiredItem;
import me.filoghost.chestcommands.parsing.ItemStackParser;
import me.filoghost.chestcommands.parsing.ParseException;

public class RequiredItemsAttribute
implements IconAttribute {
    private final List<RequiredItem> requiredItems = new ArrayList<RequiredItem>();

    public RequiredItemsAttribute(List<String> serializedRequiredItems, AttributeErrorHandler errorHandler) {
        for (String serializedItem : serializedRequiredItems) {
            try {
                ItemStackParser itemReader = new ItemStackParser(serializedItem, true);
                itemReader.checkNotAir();
                RequiredItem requiredItem = new RequiredItem(itemReader.getMaterial(), itemReader.getAmount());
                if (itemReader.hasExplicitDurability()) {
                    requiredItem.setRestrictiveDurability(itemReader.getDurability());
                }
                this.requiredItems.add(requiredItem);
            }
            catch (ParseException e) {
                errorHandler.onListElementError(serializedItem, e);
            }
        }
    }

    @Override
    public void apply(InternalConfigurableIcon icon) {
        icon.setRequiredItems(this.requiredItems);
    }
}

