/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.command;

import me.filoghost.chestcommands.ChestCommands;
import me.filoghost.chestcommands.fcommons.command.CommandException;
import me.filoghost.chestcommands.fcommons.command.CommandValidate;
import me.filoghost.chestcommands.fcommons.command.annotation.Description;
import me.filoghost.chestcommands.fcommons.command.annotation.DisplayPriority;
import me.filoghost.chestcommands.fcommons.command.annotation.MinArgs;
import me.filoghost.chestcommands.fcommons.command.annotation.Name;
import me.filoghost.chestcommands.fcommons.command.annotation.Permission;
import me.filoghost.chestcommands.fcommons.command.annotation.UsageArgs;
import me.filoghost.chestcommands.fcommons.command.multi.MultiCommandManager;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommand;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommandSession;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.menu.InternalMenu;
import me.filoghost.chestcommands.menu.MenuManager;
import me.filoghost.chestcommands.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
extends MultiCommandManager {
    public CommandHandler(String label) {
        super(label);
    }

    @Override
    protected String getSubCommandDefaultPermission(SubCommand subCommand) {
        return "chestcommands.command.." + subCommand.getName();
    }

    @Override
    protected void sendNoArgsMessage(CommandSender sender, String rootCommandLabel) {
        sender.sendMessage(ChestCommands.CHAT_PREFIX);
        sender.sendMessage(ChatColor.GREEN + "Version: " + ChatColor.GRAY + ChestCommands.getInstance().getDescription().getVersion());
        sender.sendMessage(ChatColor.GREEN + "Developer: " + ChatColor.GRAY + "filoghost");
        sender.sendMessage(ChatColor.GREEN + "Commands: " + ChatColor.GRAY + "/" + rootCommandLabel + " help");
    }

    @Override
    protected void sendUnknownSubCommandMessage(SubCommandSession session) {
        session.getSender().sendMessage(ChatColor.RED + "Unknown sub-command \"" + session.getSubLabelUsed() + "\". Use \"/" + session.getRootLabelUsed() + " help\" to see available commands.");
    }

    @Name(value="help")
    @Permission(value="chestcommands.command.help")
    public void help(CommandSender sender, SubCommandSession session) {
        sender.sendMessage(ChestCommands.CHAT_PREFIX + "Commands:");
        for (SubCommand subCommand : this.getAllSubCommands()) {
            if (subCommand == session.getSubCommand()) continue;
            String usageText = this.getUsageText(session.getRootLabelUsed(), subCommand);
            sender.sendMessage(ChatColor.WHITE + usageText + ChatColor.GRAY + " - " + subCommand.getDescription());
        }
    }

    @Name(value="reload")
    @Description(value="Reloads the plugin.")
    @Permission(value="chestcommands.command.reload")
    @DisplayPriority(value=100)
    public void reload(CommandSender sender) {
        MenuManager.closeAllOpenMenuViews();
        ErrorCollector errorCollector = ChestCommands.load();
        if (!errorCollector.hasErrors()) {
            sender.sendMessage(ChestCommands.CHAT_PREFIX + "Plugin reloaded.");
        } else {
            errorCollector.logToConsole();
            sender.sendMessage(ChestCommands.CHAT_PREFIX + ChatColor.RED + "Plugin reloaded with " + errorCollector.getErrorsCount() + " error(s).");
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(ChestCommands.CHAT_PREFIX + ChatColor.RED + "Please check the console.");
            }
        }
    }

    @Name(value="errors")
    @Description(value="Displays the last load errors on the console.")
    @Permission(value="chestcommands.command.errors")
    @DisplayPriority(value=3)
    public void errors(CommandSender sender) {
        ErrorCollector errorCollector = ChestCommands.getLastLoadErrors();
        if (errorCollector.hasErrors()) {
            errorCollector.logToConsole();
            sender.sendMessage(ChestCommands.CHAT_PREFIX + ChatColor.RED + "Last time the plugin loaded, " + errorCollector.getErrorsCount() + " error(s) were found.");
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(ChestCommands.CHAT_PREFIX + ChatColor.RED + "Errors were printed on the console.");
            }
        } else {
            sender.sendMessage(ChestCommands.CHAT_PREFIX + ChatColor.GREEN + "Last plugin load was successful, no errors logged.");
        }
    }

    @Name(value="list")
    @Description(value="Lists the loaded menus.")
    @Permission(value="chestcommands.command.list")
    @DisplayPriority(value=2)
    public void list(CommandSender sender) {
        sender.sendMessage(ChestCommands.CHAT_PREFIX + "Loaded menus:");
        for (String file : MenuManager.getMenuFileNames()) {
            sender.sendMessage(ChatColor.GRAY + "- " + ChatColor.WHITE + file);
        }
    }

    @Name(value="open")
    @Description(value="Opens a menu for a player.")
    @Permission(value="chestcommands.command.open")
    @MinArgs(value=1)
    @UsageArgs(value="<menu> [player]")
    @DisplayPriority(value=1)
    public void open(CommandSender sender, String[] args) throws CommandException {
        Player target;
        if (sender instanceof Player) {
            if (args.length > 1) {
                CommandValidate.check(sender.hasPermission("chestcommands.command.open.others"), "You don't have the permission to open a menu for other players.");
                target = Bukkit.getPlayerExact((String)args[1]);
            } else {
                target = (Player)sender;
            }
        } else {
            CommandValidate.minLength(args, 2, "You must specify a player from the console.");
            target = Bukkit.getPlayerExact((String)args[1]);
        }
        CommandValidate.notNull(target, "That player is not online.");
        String menuName = Utils.addYamlExtension(args[0]);
        InternalMenu menu = MenuManager.getMenuByFileName(menuName);
        CommandValidate.notNull(menu, "The menu \"" + menuName + "\" was not found.");
        if (!sender.hasPermission(menu.getOpenPermission())) {
            menu.sendNoOpenPermissionMessage(sender);
            return;
        }
        if (sender.getName().equalsIgnoreCase(target.getName())) {
            sender.sendMessage(ChatColor.GREEN + "Opening the menu " + menuName + ".");
        } else {
            sender.sendMessage(ChatColor.GREEN + "Opening the menu " + menuName + " to " + target.getName() + ".");
        }
        menu.open(target);
    }
}

