/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.config;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.filoghost.chestcommands.config.CustomPlaceholders;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.config.Settings;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.BaseConfigManager;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigException;
import me.filoghost.chestcommands.fcommons.config.mapped.MappedConfigLoader;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.menu.LoadedMenu;
import me.filoghost.chestcommands.parsing.menu.MenuParser;

public class ConfigManager
extends BaseConfigManager {
    private final MappedConfigLoader<Settings> settingsConfigLoader = this.getMappedConfigLoader("config.yml", Settings.class);
    private final ConfigLoader placeholdersConfigLoader = this.getConfigLoader("custom-placeholders.yml");
    private final MappedConfigLoader<Lang> langConfigLoader = this.getMappedConfigLoader("lang.yml", Lang.class);

    public ConfigManager(Path rootDataFolder) {
        super(rootDataFolder);
    }

    public void tryLoadSettings(ErrorCollector errorCollector) {
        try {
            this.settingsConfigLoader.init();
        }
        catch (ConfigException e) {
            this.logConfigInitException(errorCollector, this.settingsConfigLoader.getFile(), e);
        }
    }

    public void tryLoadLang(ErrorCollector errorCollector) {
        try {
            this.langConfigLoader.init();
        }
        catch (ConfigException e) {
            this.logConfigInitException(errorCollector, this.langConfigLoader.getFile(), e);
        }
    }

    public CustomPlaceholders tryLoadCustomPlaceholders(ErrorCollector errorCollector) {
        CustomPlaceholders placeholders = new CustomPlaceholders();
        try {
            FileConfig placeholdersConfig = this.placeholdersConfigLoader.init();
            placeholders.load(placeholdersConfig, errorCollector);
        }
        catch (ConfigException t) {
            this.logConfigInitException(errorCollector, this.placeholdersConfigLoader.getFile(), t);
        }
        return placeholders;
    }

    public void tryCreateDefault(ErrorCollector errorCollector, ConfigLoader configLoader) {
        try {
            configLoader.createDefault();
        }
        catch (ConfigException e) {
            this.logConfigInitException(errorCollector, configLoader.getFile(), e);
        }
    }

    public Path getMenusFolder() {
        return this.rootDataFolder.resolve("menu");
    }

    public List<Path> getMenuFiles() throws IOException {
        Preconditions.checkState(Files.isDirectory(this.getMenusFolder(), new LinkOption[0]), "menus folder doesn't exist");
        try (Stream<Path> paths = Files.walk(this.getMenusFolder(), FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = paths.filter(this::isYamlFile).collect(Collectors.toList());
            return list;
        }
    }

    private void logConfigInitException(ErrorCollector errorCollector, Path file, ConfigException e) {
        errorCollector.add(e, Errors.Config.initException(file));
    }

    public List<LoadedMenu> tryLoadMenus(ErrorCollector errorCollector) {
        List<Path> menuFiles;
        ArrayList<LoadedMenu> loadedMenus = new ArrayList<LoadedMenu>();
        try {
            menuFiles = this.getMenuFiles();
        }
        catch (IOException e) {
            errorCollector.add(e, Errors.Config.menuListIOException(this.getMenusFolder()));
            return Collections.emptyList();
        }
        for (Path menuFile : menuFiles) {
            ConfigLoader menuConfigLoader = new ConfigLoader(this.rootDataFolder, menuFile);
            try {
                FileConfig menuConfig = menuConfigLoader.load();
                loadedMenus.add(MenuParser.loadMenu(menuConfig, errorCollector));
            }
            catch (ConfigException e) {
                this.logConfigInitException(errorCollector, menuConfigLoader.getFile(), e);
            }
        }
        return loadedMenus;
    }

    private boolean isYamlFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(".yml");
    }
}

