/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.config;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.fcommons.Colors;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.placeholder.StaticPlaceholder;

public class CustomPlaceholders {
    private final List<StaticPlaceholder> placeholders = new ArrayList<StaticPlaceholder>();

    public void load(FileConfig config, ErrorCollector errorCollector) {
        this.placeholders.clear();
        ConfigSection placeholdersSection = config.getConfigSection("placeholders");
        if (placeholdersSection == null) {
            return;
        }
        for (String placeholder : placeholdersSection.getKeys()) {
            String replacement = Colors.addColors(placeholdersSection.getString(placeholder));
            if (replacement == null) {
                return;
            }
            if (placeholder.length() == 0) {
                errorCollector.add(Errors.Config.emptyPlaceholder(config.getSourceFile()));
                continue;
            }
            if (placeholder.length() > 100) {
                errorCollector.add(Errors.Config.tooLongPlaceholder(config.getSourceFile(), placeholder));
                continue;
            }
            this.placeholders.add(new StaticPlaceholder(placeholder, replacement));
        }
    }

    public List<StaticPlaceholder> getPlaceholders() {
        return this.placeholders;
    }
}

