/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons;

import java.util.ArrayList;
import me.filoghost.chestcommands.fcommons.CommonsUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseJavaPlugin
extends JavaPlugin {
    public final void onEnable() {
        try {
            this.checkPackageRelocation();
            this.onCheckedEnable();
        }
        catch (PluginEnableException e) {
            this.criticalShutdown(e.getMessage(), null);
        }
        catch (Throwable t) {
            this.criticalShutdown(null, t);
        }
    }

    private void checkPackageRelocation() {
        String defaultPackage = "me-filoghost-fcommons".replace("-", ".");
        if (BaseJavaPlugin.class.getPackage().getName().equals(defaultPackage)) {
            throw new IllegalStateException("FCommons must be relocated to another package");
        }
    }

    protected abstract void onCheckedEnable() throws PluginEnableException;

    private void criticalShutdown(String errorMessage, Throwable throwable) {
        Bukkit.getConsoleSender().sendMessage(this.getErrorMessage(errorMessage, throwable));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> Bukkit.getConsoleSender().sendMessage(this.getFatalErrorPrefix() + "Fatal error while enabling the plugin. Check previous logs for more information."), 10L);
        this.setEnabled(false);
    }

    protected String getErrorMessage(String errorMessage, Throwable throwable) {
        ArrayList<String> output = new ArrayList<String>();
        if (throwable != null) {
            output.add(this.getFatalErrorPrefix() + "Fatal unexpected error while enabling plugin:");
        } else {
            output.add(this.getFatalErrorPrefix() + "Fatal error while enabling plugin:");
        }
        if (throwable != null) {
            output.add(" ");
            output.add(CommonsUtil.getStackTraceString(throwable));
        }
        output.add(" ");
        if (errorMessage != null) {
            output.add(errorMessage);
        }
        output.add("The plugin has been disabled.");
        output.add(" ");
        return String.join((CharSequence)"\n", output);
    }

    private String getFatalErrorPrefix() {
        return ChatColor.DARK_RED + "[" + this.getDescription().getName() + "] " + ChatColor.RED;
    }

    public static class PluginEnableException
    extends Exception {
        public PluginEnableException(String message) {
            super(message);
        }
    }
}

