/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons;

import me.filoghost.chestcommands.fcommons.FeatureSupport;
import me.filoghost.chestcommands.fcommons.Strings;

public final class Colors {
    private static final int HEX_COLOR_LENGTH = 6;

    public static String addColors(String input) {
        if (Strings.isEmpty(input) || !input.contains("&")) {
            return input;
        }
        StringBuilder output = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (current == '&' && i + 1 < input.length()) {
                char next = input.charAt(i + 1);
                if (next == '#' && FeatureSupport.HEX_CHAT_COLORS && Colors.isValidHexColor(input, i + 2)) {
                    output.append('\u00a7');
                    output.append('x');
                    for (int j = 0; j < 6; ++j) {
                        output.append('\u00a7');
                        output.append(Character.toLowerCase(input.charAt(i + 2 + j)));
                    }
                    i += 7;
                    continue;
                }
                if (Colors.isColorCode(next)) {
                    output.append('\u00a7');
                    output.append(Character.toLowerCase(next));
                    ++i;
                    continue;
                }
                output.append(current);
                continue;
            }
            output.append(current);
        }
        return output.toString();
    }

    private static boolean isValidHexColor(String input, int startIndex) {
        if (input.length() - startIndex < 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Colors.isHexCode(input.charAt(startIndex + i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexCode(char c) {
        return "0123456789AaBbCcDdEeFf".indexOf(c) > -1;
    }

    private static boolean isColorCode(char c) {
        return "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(c) > -1;
    }
}

