/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.filoghost.chestcommands.fcommons.Preconditions;

public class CaseInsensitiveMap<V>
implements Map<String, V> {
    private final Map<String, V> delegate;

    public CaseInsensitiveMap() {
        this(new HashMap());
    }

    public CaseInsensitiveMap(Map<String, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V put(String key, V value) {
        return this.delegate.put(this.getLowercaseKey(key), value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(this.getLowercaseKey(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.getLowercaseKey(key));
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(this.getLowercaseKey(key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    private String getLowercaseKey(Object key) {
        Preconditions.notNull(key, "key");
        Preconditions.checkArgument(key instanceof String, "key must be a string");
        return ((String)key).toLowerCase();
    }
}

