/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.Strings;

public class Registry<T> {
    private static final char[] KEY_IGNORE_CHARS = new char[]{'-', '_', ' '};
    private final Class<T> valuesType;
    private final Map<String, T> valuesMap;

    public static <T extends Enum<T>> Registry<T> fromEnumValues(Class<T> enumClass) {
        Registry<T> registry = new Registry<T>(enumClass);
        super.putAll(enumClass.getEnumConstants(), Enum::name);
        return registry;
    }

    public static <T> Registry<T> fromValues(T[] values, Function<T, String> toKeyFunction) {
        Registry<T> registry = new Registry<T>(null);
        super.putAll(values, toKeyFunction);
        return registry;
    }

    private Registry(Class<T> valuesType) {
        this.valuesType = valuesType;
        this.valuesMap = new HashMap<String, T>();
    }

    public Optional<T> find(String key) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.valuesMap.get(this.toKeyFormat(key)));
    }

    public void putIfEnumExists(String key, String enumValueName) {
        Preconditions.checkState(this.valuesType.isEnum(), "value type is not an enum");
        try {
            T enumValue = Enum.valueOf(this.valuesType, enumValueName);
            this.put(key, enumValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void putAll(T[] enumValues, Function<T, String> toKeyFunction) {
        for (T enumValue : enumValues) {
            this.valuesMap.put(this.toKeyFormat(toKeyFunction.apply(enumValue)), enumValue);
        }
    }

    public void put(String key, T enumValue) {
        this.valuesMap.put(this.toKeyFormat(key), enumValue);
    }

    private String toKeyFormat(String enumValueName) {
        return Strings.stripChars(enumValueName, KEY_IGNORE_CHARS).toLowerCase();
    }

    public String toString() {
        return "Registry [type=" + this.valuesType + ", values=" + this.valuesMap + "]";
    }
}

