/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.command;

import me.filoghost.chestcommands.fcommons.command.CommandException;
import me.filoghost.chestcommands.fcommons.command.annotation.Permission;
import me.filoghost.chestcommands.fcommons.command.annotation.PermissionMessage;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandManager
implements CommandExecutor {
    private final String label;

    public CommandManager(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean register(JavaPlugin plugin) {
        PermissionMessage noPermissionMessage;
        PluginCommand pluginCommand = plugin.getCommand(this.label);
        if (pluginCommand == null) {
            return false;
        }
        Permission permission = this.getClass().getAnnotation(Permission.class);
        if (permission != null) {
            pluginCommand.setPermission(permission.value());
        }
        if ((noPermissionMessage = this.getClass().getAnnotation(PermissionMessage.class)) != null) {
            pluginCommand.setPermissionMessage(noPermissionMessage.value());
        } else {
            pluginCommand.setPermissionMessage(this.getDefaultPermissionMessage());
        }
        pluginCommand.setExecutor((CommandExecutor)this);
        return true;
    }

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block2: {
            try {
                this.execute(sender, label, args);
            }
            catch (CommandException ex) {
                if (ex.getMessage() == null || ex.getMessage().isEmpty()) break block2;
                sender.sendMessage(this.formatCommandExceptionMessage(ex.getMessage()));
            }
        }
        return true;
    }

    public abstract void execute(CommandSender var1, String var2, String[] var3) throws CommandException;

    protected String formatCommandExceptionMessage(String message) {
        return ChatColor.RED + message;
    }

    protected String getDefaultPermissionMessage() {
        return ChatColor.RED + "You don't have permission for this command.";
    }
}

