/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.command.multi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.filoghost.chestcommands.fcommons.command.CommandException;
import me.filoghost.chestcommands.fcommons.command.annotation.Description;
import me.filoghost.chestcommands.fcommons.command.annotation.DisplayPriority;
import me.filoghost.chestcommands.fcommons.command.annotation.MinArgs;
import me.filoghost.chestcommands.fcommons.command.annotation.Name;
import me.filoghost.chestcommands.fcommons.command.annotation.Permission;
import me.filoghost.chestcommands.fcommons.command.annotation.PermissionMessage;
import me.filoghost.chestcommands.fcommons.command.annotation.UsageArgs;
import me.filoghost.chestcommands.fcommons.command.multi.SimpleSubCommand;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommand;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommandSession;
import org.bukkit.command.CommandSender;

public class MethodReflectionSubCommand
extends SimpleSubCommand {
    private final Object instance;
    private final Method method;
    private final Class<?>[] methodParameterTypes;
    private static final Map<Class<?>, Function<SubCommandSession, ?>> parameterProviders = new HashMap();

    protected MethodReflectionSubCommand(Object instance, Method method) {
        super(MethodReflectionSubCommand.getNameAnnotation(method).value());
        Description description;
        DisplayPriority displayPriority;
        MinArgs minArgs;
        UsageArgs usage;
        PermissionMessage permissionMessage;
        Class<?>[] params;
        this.instance = instance;
        this.method = method;
        this.method.setAccessible(true);
        for (Class<?> param : params = method.getParameterTypes()) {
            if (parameterProviders.containsKey(param)) continue;
            throw new IllegalArgumentException("Method " + method.getName() + " contains unsupported parameter type: " + param.getSimpleName());
        }
        this.methodParameterTypes = params;
        Permission permission = method.getAnnotation(Permission.class);
        if (permission != null) {
            this.setPermission(permission.value());
        }
        if ((permissionMessage = method.getAnnotation(PermissionMessage.class)) != null) {
            this.setPermissionMessage(permissionMessage.value());
        }
        if ((usage = method.getAnnotation(UsageArgs.class)) != null) {
            this.setUsageArgs(usage.value());
        }
        if ((minArgs = method.getAnnotation(MinArgs.class)) != null) {
            this.setMinArgs(minArgs.value());
        }
        if ((displayPriority = method.getAnnotation(DisplayPriority.class)) != null) {
            this.setDisplayPriority(displayPriority.value());
        }
        if ((description = method.getAnnotation(Description.class)) != null) {
            this.setDescription(description.value());
        }
    }

    private static Name getNameAnnotation(Method method) {
        Name name = method.getAnnotation(Name.class);
        if (name == null) {
            throw new IllegalArgumentException("Missing @Name annotation");
        }
        return name;
    }

    @Override
    public void execute(SubCommandSession subCommandSession) throws CommandException {
        Object[] methodParameters = new Object[this.methodParameterTypes.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            methodParameters[i] = parameterProviders.get(this.methodParameterTypes[i]).apply(subCommandSession);
        }
        try {
            this.method.invoke(this.instance, methodParameters);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        parameterProviders.put(SubCommandSession.class, Function.identity());
        parameterProviders.put(CommandSender.class, SubCommandSession::getSender);
        parameterProviders.put(SubCommand.class, SubCommandSession::getSubCommand);
        parameterProviders.put(String[].class, SubCommandSession::getArgs);
    }
}

