/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.command.multi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.command.CommandException;
import me.filoghost.chestcommands.fcommons.command.CommandManager;
import me.filoghost.chestcommands.fcommons.command.annotation.Name;
import me.filoghost.chestcommands.fcommons.command.multi.MethodReflectionSubCommand;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommand;
import me.filoghost.chestcommands.fcommons.command.multi.SubCommandSession;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public abstract class MultiCommandManager
extends CommandManager {
    private final Set<SubCommand> subCommands = new TreeSet<SubCommand>(Comparator.comparing(SubCommand::getDisplayPriority).reversed().thenComparing(SubCommand::getName, String.CASE_INSENSITIVE_ORDER));

    public MultiCommandManager(String label) {
        super(label);
        this.scanSubCommands();
    }

    private void scanSubCommands() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Name.class)) continue;
            MethodReflectionSubCommand subCommand = new MethodReflectionSubCommand(this, method);
            this.registerSubCommand(subCommand);
        }
    }

    protected final void registerSubCommand(SubCommand subCommand) {
        Preconditions.notNull(subCommand, "subCommand");
        Preconditions.notNull(subCommand.getName(), "subCommand's name");
        this.subCommands.add(subCommand);
    }

    @Override
    public final void execute(CommandSender sender, String rootLabelUsed, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendNoArgsMessage(sender, rootLabelUsed);
            return;
        }
        String subLabelUsed = args[0];
        SubCommand subCommand = this.getSubCommand(subLabelUsed);
        String[] subCommandArgs = Arrays.copyOfRange(args, 1, args.length);
        SubCommandSession subCommandSession = new SubCommandSession(sender, subCommand, rootLabelUsed, subLabelUsed, subCommandArgs);
        if (subCommand == null) {
            this.sendUnknownSubCommandMessage(subCommandSession);
            return;
        }
        String permission = this.getSubCommandDefaultPermission(subCommand);
        if (!Strings.isEmpty(subCommand.getPermission())) {
            permission = subCommand.getPermission();
        }
        if (!Strings.isEmpty(permission) && !sender.hasPermission(permission)) {
            if (subCommand.getPermissionMessage() != null) {
                sender.sendMessage(subCommand.getPermissionMessage());
            } else {
                this.sendSubCommandDefaultPermissionMessage(subCommandSession);
            }
            return;
        }
        if (subCommandArgs.length < subCommand.getMinArgs()) {
            this.sendSubCommandUsage(subCommandSession);
            return;
        }
        subCommand.execute(subCommandSession);
    }

    private SubCommand getSubCommand(String label) {
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.getName().equalsIgnoreCase(label)) continue;
            return subCommand;
        }
        return null;
    }

    protected final List<SubCommand> getAllSubCommands() {
        return new ArrayList<SubCommand>(this.subCommands);
    }

    protected final List<SubCommand> getAccessibleSubCommands(Permissible sender) {
        ArrayList<SubCommand> list = new ArrayList<SubCommand>();
        for (SubCommand subCommand : this.subCommands) {
            if (subCommand.getPermission() != null && !sender.hasPermission(subCommand.getPermission())) continue;
            list.add(subCommand);
        }
        return list;
    }

    protected String getSubCommandDefaultPermission(SubCommand subCommand) {
        return null;
    }

    protected void sendSubCommandUsage(SubCommandSession session) {
        String usageText = this.getUsageText(session.getRootLabelUsed(), session.getSubCommand());
        session.getSender().sendMessage(ChatColor.RED + "Command usage: " + usageText);
    }

    protected void sendSubCommandDefaultPermissionMessage(SubCommandSession subCommandSession) {
        subCommandSession.getSender().sendMessage(ChatColor.RED + "You don't have permission for this sub-command.");
    }

    protected void sendUnknownSubCommandMessage(SubCommandSession session) {
        session.getSender().sendMessage(ChatColor.RED + "Unknown sub-command \"" + session.getSubLabelUsed() + "\". Use /" + session.getRootLabelUsed() + " to see available commands.");
    }

    protected void sendNoArgsMessage(CommandSender sender, String rootLabelUsed) {
        sender.sendMessage("/" + rootLabelUsed + " commands:");
        for (SubCommand subCommand : this.getAllSubCommands()) {
            sender.sendMessage(ChatColor.GRAY + this.getUsageText(rootLabelUsed, subCommand));
        }
    }

    protected final String getUsageText(String rootCommandName, SubCommand subCommand) {
        return this.getUsageText(rootCommandName, subCommand.getName(), subCommand.getUsageArgs());
    }

    protected String getUsageText(String rootCommandName, String subCommandName, String usageArgs) {
        return "/" + rootCommandName + " " + subCommandName + (usageArgs != null ? " " + usageArgs : "");
    }
}

