/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.YamlSerializer;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;

public class Config
extends ConfigSection {
    private final YamlSerializer yamlSerializer = new YamlSerializer();
    private List<String> header;

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(String ... header) {
        this.setHeader(Arrays.asList(header));
    }

    public void setHeader(List<String> header) {
        this.header = ImmutableList.copyOf(header);
    }

    protected void loadFromString(List<String> fileContents) throws ConfigLoadException {
        Preconditions.notNull(fileContents, "fileContents cannot be null");
        LinkedHashMap<String, Object> internalValues = this.yamlSerializer.parseConfigValues(fileContents);
        if (internalValues == null) {
            internalValues = new LinkedHashMap();
        }
        this.setHeader(this.yamlSerializer.parseHeader(fileContents));
        this.setInternalValues(internalValues);
    }

    protected String saveToString() {
        String serializedHeader = this.yamlSerializer.serializeHeader(this.header);
        String serializedValues = this.yamlSerializer.serializeConfigValues(this.getInternalValues());
        return serializedHeader + serializedValues;
    }
}

