/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.Config;
import me.filoghost.chestcommands.fcommons.config.ConfigErrors;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;

public class ConfigLoader {
    private final Path rootDataFolder;
    private final Path file;

    public ConfigLoader(Path rootDataFolder, Path file) {
        Preconditions.checkArgument(file.startsWith(rootDataFolder), "file \"" + file + "\" must be inside \"" + rootDataFolder + "\"");
        this.rootDataFolder = rootDataFolder;
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    public boolean fileExists() {
        return Files.isRegularFile(this.file, new LinkOption[0]);
    }

    public FileConfig init() throws ConfigSaveException, ConfigLoadException {
        this.createDefault();
        return this.load();
    }

    public FileConfig load() throws ConfigLoadException {
        Preconditions.checkState(this.fileExists(), "\"" + this.file + "\" doesn't exist or is not a regular file");
        FileConfig config = new FileConfig(this.file);
        try {
            config.loadFromString(Files.readAllLines(this.file));
        }
        catch (IOException e) {
            throw new ConfigLoadException("I/O exception while reading file", e);
        }
        return config;
    }

    public void save(Config config) throws ConfigSaveException {
        this.createParentDirectory();
        String data = config.saveToString();
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            writer.write(data);
        }
        catch (IOException e) {
            throw new ConfigSaveException("I/O exception while writing data to file", e);
        }
    }

    public void createDefault() throws ConfigSaveException {
        if (this.fileExists()) {
            return;
        }
        this.createParentDirectory();
        Path relativeConfigPath = this.rootDataFolder.relativize(this.file);
        String internalJarPath = this.toInternalJarPath(relativeConfigPath);
        try (InputStream defaultFile = this.getInternalResource(internalJarPath);){
            if (defaultFile != null) {
                Files.copy(defaultFile, this.file, new CopyOption[0]);
            } else {
                Files.createFile(this.file, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new ConfigSaveException("I/O exception while creating default file", e);
        }
    }

    private void createParentDirectory() throws ConfigSaveException {
        if (this.file.getParent() != null) {
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ConfigSaveException(ConfigErrors.createParentFolderIOException(this.rootDataFolder, this.file.getParent()), e);
            }
        }
    }

    private String toInternalJarPath(Path path) {
        return StreamSupport.stream(path.spliterator(), false).map(Path::toString).collect(Collectors.joining("/", "/", ""));
    }

    private InputStream getInternalResource(String internalJarPath) throws IOException {
        Preconditions.notNull(internalJarPath, "internalJarPath");
        URL resourceURL = this.getClass().getResource(internalJarPath);
        if (resourceURL == null) {
            return null;
        }
        URLConnection connection = resourceURL.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }
}

