/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.chestcommands.fcommons.config.exception.MissingConfigValueException;

public class ConfigSection {
    private LinkedHashMap<String, Object> values;

    public ConfigSection() {
        this.setInternalValues(new LinkedHashMap<String, Object>());
    }

    protected ConfigSection(LinkedHashMap<String, Object> values) {
        this.setInternalValues(values);
    }

    protected void setInternalValues(LinkedHashMap<String, Object> values) {
        Preconditions.notNull(values, "values");
        this.values = values;
    }

    protected LinkedHashMap<String, Object> getInternalValues() {
        return this.values;
    }

    public ConfigValue get(String path) {
        return ConfigValue.ofRawConfigValue(path, this.getRawValue(path));
    }

    public <T> T get(String path, ConfigValueType<T> configValueType) {
        return this.getOrDefault(path, configValueType, null);
    }

    public <T> T getRequired(String path, ConfigValueType<T> configValueType) throws MissingConfigValueException, InvalidConfigValueException {
        return configValueType.fromConfigValueRequired(path, this.getRawValue(path));
    }

    public <T> T getOrDefault(String path, ConfigValueType<T> configValueType, T defaultValue) {
        return configValueType.fromConfigValueOrDefault(this.getRawValue(path), defaultValue);
    }

    public <T> void set(String path, ConfigValue configValue) {
        this.setRawValue(path, configValue.getRawConfigValue());
    }

    public <T> void set(String path, ConfigValueType<T> configValueType, T value) {
        this.setRawValue(path, configValueType.toConfigValueOrNull(value));
    }

    public boolean contains(String path) {
        return this.getRawValue(path) != null;
    }

    public void remove(String path) {
        this.setRawValue(path, null);
    }

    public ConfigSection getOrCreateSection(String path) {
        ConfigSection section = this.getConfigSection(path);
        if (section == null) {
            section = new ConfigSection();
            this.setConfigSection(path, section);
        }
        return section;
    }

    public Set<String> getKeys() {
        return new LinkedHashSet<String>(this.values.keySet());
    }

    private Object getRawValue(String path) {
        Preconditions.notEmpty(path, "path");
        int separatorIndex = path.indexOf(46);
        if (separatorIndex >= 0) {
            String firstPath = path.substring(0, separatorIndex);
            String remainingPath = path.substring(separatorIndex + 1);
            ConfigSection section = this.getConfigSection(firstPath);
            if (section != null) {
                return section.getRawValue(remainingPath);
            }
            return null;
        }
        return this.values.get(path);
    }

    private void setRawValue(String path, Object value) {
        Preconditions.notEmpty(path, "path");
        int separatorIndex = path.indexOf(46);
        if (separatorIndex >= 0) {
            String firstPath = path.substring(0, separatorIndex);
            String remainingPath = path.substring(separatorIndex + 1);
            ConfigSection section = this.getConfigSection(firstPath);
            if (section == null) {
                if (value == null) {
                    return;
                }
                section = this.getOrCreateSection(firstPath);
            }
            section.setRawValue(remainingPath, value);
        } else if (value != null) {
            this.values.put(path, value);
        } else {
            this.values.remove(path);
        }
    }

    public String getRequiredString(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.STRING);
    }

    public boolean getRequiredBoolean(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.BOOLEAN);
    }

    public int getRequiredInt(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.INTEGER);
    }

    public double getRequiredDouble(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.DOUBLE);
    }

    public List<String> getRequiredStringList(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.STRING_LIST);
    }

    public ConfigSection getRequiredConfigSection(String path) throws MissingConfigValueException, InvalidConfigValueException {
        return this.getRequired(path, ConfigValueType.SECTION);
    }

    public String getString(String path) {
        return this.getOrDefault(path, ConfigValueType.STRING, null);
    }

    public boolean getBoolean(String path) {
        return this.getOrDefault(path, ConfigValueType.BOOLEAN, false);
    }

    public int getInt(String path) {
        return this.getOrDefault(path, ConfigValueType.INTEGER, 0);
    }

    public double getDouble(String path) {
        return this.getOrDefault(path, ConfigValueType.DOUBLE, 0.0);
    }

    public List<String> getStringList(String path) {
        return this.getOrDefault(path, ConfigValueType.STRING_LIST, null);
    }

    public ConfigSection getConfigSection(String path) {
        return this.getOrDefault(path, ConfigValueType.SECTION, null);
    }

    public String getString(String path, String defaultValue) {
        return this.getOrDefault(path, ConfigValueType.STRING, defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.getOrDefault(path, ConfigValueType.BOOLEAN, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.getOrDefault(path, ConfigValueType.INTEGER, defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.getOrDefault(path, ConfigValueType.DOUBLE, defaultValue);
    }

    public List<String> getStringList(String path, List<String> defaultValue) {
        return this.getOrDefault(path, ConfigValueType.STRING_LIST, defaultValue);
    }

    public ConfigSection getConfigSection(String path, ConfigSection defaultValue) {
        return this.getOrDefault(path, ConfigValueType.SECTION, defaultValue);
    }

    public void setString(String path, String value) {
        this.set(path, ConfigValueType.STRING, value);
    }

    public void setBoolean(String path, boolean value) {
        this.set(path, ConfigValueType.BOOLEAN, value);
    }

    public void setInt(String path, int value) {
        this.set(path, ConfigValueType.INTEGER, value);
    }

    public void setDouble(String path, double value) {
        this.set(path, ConfigValueType.DOUBLE, value);
    }

    public void setStringList(String path, List<String> value) {
        this.set(path, ConfigValueType.STRING_LIST, value);
    }

    public void setConfigSection(String path, ConfigSection value) {
        this.set(path, ConfigValueType.SECTION, value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfigSection)) {
            return false;
        }
        ConfigSection other = (ConfigSection)obj;
        return this.values.equals(other.values);
    }

    public final int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return this.values.toString();
    }
}

