/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import java.util.Objects;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.chestcommands.fcommons.config.exception.MissingConfigValueException;

public final class ConfigValue {
    public static final ConfigValue NULL = new ConfigValue(null, null);
    private final String path;
    private final Object rawConfigValue;

    public static <T> ConfigValue of(ConfigValueType<T> valueType, T value) {
        Preconditions.notNull(valueType, "valueType");
        Preconditions.notNull(value, "value");
        return new ConfigValue(null, valueType.toConfigValue(value));
    }

    protected static ConfigValue ofRawConfigValue(String path, Object rawConfigValue) {
        return new ConfigValue(path, rawConfigValue);
    }

    private ConfigValue(String path, Object rawConfigValue) {
        this.path = path;
        this.rawConfigValue = rawConfigValue;
    }

    protected Object getRawConfigValue() {
        return this.rawConfigValue;
    }

    public final <T> T as(ConfigValueType<T> valueType) {
        return valueType.fromConfigValueOrDefault(this.rawConfigValue, null);
    }

    public final <T> T asRequired(ConfigValueType<T> valueType) throws MissingConfigValueException, InvalidConfigValueException {
        return valueType.fromConfigValueRequired(this.path, this.rawConfigValue);
    }

    public final <T> T asOrDefault(ConfigValueType<T> valueType, T defaultValue) {
        return valueType.fromConfigValueOrDefault(this.rawConfigValue, defaultValue);
    }

    public boolean isPresentAs(ConfigValueType<?> configValueType) {
        return configValueType.isValidNonNullConfigValue(this.rawConfigValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigValue other = (ConfigValue)obj;
        return Objects.equals(this.rawConfigValue, other.rawConfigValue);
    }

    public int hashCode() {
        return Objects.hash(this.rawConfigValue);
    }

    public String toString() {
        return Objects.toString(this.rawConfigValue);
    }
}

