/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import java.util.List;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.chestcommands.fcommons.config.exception.MissingConfigValueException;
import me.filoghost.chestcommands.fcommons.config.valuetype.BooleanConfigValueType;
import me.filoghost.chestcommands.fcommons.config.valuetype.ListConfigValueType;
import me.filoghost.chestcommands.fcommons.config.valuetype.NumberConfigValueType;
import me.filoghost.chestcommands.fcommons.config.valuetype.SectionConfigValueType;
import me.filoghost.chestcommands.fcommons.config.valuetype.StringConfigValueType;
import me.filoghost.chestcommands.fcommons.config.valuetype.WrappedListConfigValueType;

public abstract class ConfigValueType<T> {
    public static final ConfigValueType<String> STRING = new StringConfigValueType("STRING");
    public static final ConfigValueType<Boolean> BOOLEAN = new BooleanConfigValueType("BOOLEAN");
    public static final ConfigValueType<Long> LONG = new NumberConfigValueType<Long>("LONG", Number::longValue);
    public static final ConfigValueType<Integer> INTEGER = new NumberConfigValueType<Integer>("INTEGER", Number::intValue);
    public static final ConfigValueType<Short> SHORT = new NumberConfigValueType<Short>("SHORT", Number::shortValue);
    public static final ConfigValueType<Byte> BYTE = new NumberConfigValueType<Byte>("BYTE", Number::byteValue);
    public static final ConfigValueType<Double> DOUBLE = new NumberConfigValueType<Double>("DOUBLE", Number::doubleValue);
    public static final ConfigValueType<Float> FLOAT = new NumberConfigValueType<Float>("FLOAT", Number::floatValue);
    public static final ConfigValueType<ConfigSection> SECTION = new SectionConfigValueType("SECTION");
    public static final ConfigValueType<List<ConfigValue>> LIST = new WrappedListConfigValueType("LIST");
    public static final ConfigValueType<List<String>> STRING_LIST = new ListConfigValueType<String>("STRING_LIST", STRING);
    public static final ConfigValueType<List<Integer>> INTEGER_LIST = new ListConfigValueType<Integer>("INTEGER_LIST", INTEGER);
    public static final ConfigValueType<List<ConfigSection>> SECTION_LIST = new ListConfigValueType<ConfigSection>("SECTION_LIST", SECTION);
    private final String name;
    protected final String notConvertibleErrorMessage;

    protected ConfigValueType(String name, String notConvertibleErrorMessage) {
        this.name = name;
        this.notConvertibleErrorMessage = notConvertibleErrorMessage;
    }

    public String toString() {
        return this.name;
    }

    protected T fromConfigValueRequired(String path, Object rawConfigValue) throws MissingConfigValueException, InvalidConfigValueException {
        if (this.isValidNonNullConfigValue(rawConfigValue)) {
            return this.fromConfigValue(rawConfigValue);
        }
        if (rawConfigValue != null) {
            throw new InvalidConfigValueException(path, this.notConvertibleErrorMessage);
        }
        throw new MissingConfigValueException(path, "value is not set");
    }

    protected T fromConfigValueOrNull(Object rawConfigValue) {
        return this.fromConfigValueOrDefault(rawConfigValue, null);
    }

    protected T fromConfigValueOrDefault(Object rawConfigValue, T defaultValue) {
        if (this.isValidNonNullConfigValue(rawConfigValue)) {
            return this.fromConfigValue(rawConfigValue);
        }
        return defaultValue;
    }

    protected boolean isValidNonNullConfigValue(Object rawConfigValue) {
        return rawConfigValue != null && this.isValidConfigValue(rawConfigValue);
    }

    protected Object toConfigValueOrNull(T value) {
        if (value != null) {
            return this.toConfigValue(value);
        }
        return null;
    }

    protected ConfigValue wrapRawValue(Object rawConfigValue) {
        return ConfigValue.ofRawConfigValue(null, rawConfigValue);
    }

    protected Object unwrapRawValue(ConfigValue configValue) {
        return configValue.getRawConfigValue();
    }

    protected static <T> T fromConfigValueOrNull(ConfigValueType<T> type, Object rawConfigValue) {
        return type.fromConfigValueOrNull(rawConfigValue);
    }

    protected abstract boolean isValidConfigValue(Object var1);

    protected abstract T fromConfigValue(Object var1);

    protected abstract Object toConfigValue(T var1);
}

