/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSyntaxException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlSerializer {
    private static final String COMMENT_PREFIX = "#";
    private static final String BLANK_CONFIG = "{}\n";
    private final Yaml yaml;

    public YamlSerializer() {
        DumperOptions yamlOptions = new DumperOptions();
        yamlOptions.setIndent(2);
        yamlOptions.setWidth(Integer.MAX_VALUE);
        yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(yamlOptions);
    }

    public LinkedHashMap<String, Object> parseConfigValues(List<String> fileContents) throws ConfigLoadException {
        Preconditions.notNull(fileContents, "fileContents cannot be null");
        Map<?, ?> yamlValues = this.parseYamlMap(String.join((CharSequence)"\n", fileContents));
        if (yamlValues != null) {
            return this.yamlMapToConfigValues(yamlValues);
        }
        return null;
    }

    public String serializeConfigValues(LinkedHashMap<String, Object> configValues) {
        Map<String, Object> yamlMap = this.configValuesToYamlMap(configValues);
        return this.serializeYamlMap(yamlMap);
    }

    public List<String> parseHeader(List<String> fileContents) {
        ArrayList<String> headerLines = new ArrayList<String>();
        boolean foundHeader = false;
        for (String line : fileContents) {
            if (line.startsWith(COMMENT_PREFIX)) {
                foundHeader = true;
                int headerCommentStart = COMMENT_PREFIX.length();
                if (line.length() > headerCommentStart && Character.isWhitespace(line.charAt(headerCommentStart))) {
                    ++headerCommentStart;
                }
                String lineContent = line.substring(headerCommentStart);
                headerLines.add(lineContent);
                continue;
            }
            if (!foundHeader && Strings.isWhitespace(line)) continue;
            break;
        }
        return headerLines;
    }

    public String serializeHeader(List<String> header) {
        if (header != null && !header.isEmpty()) {
            return header.stream().map(s -> "# " + s + "\n").collect(Collectors.joining()) + "\n";
        }
        return "";
    }

    public LinkedHashMap<String, Object> yamlMapToConfigValues(Map<?, ?> yamlMap) {
        LinkedHashMap<String, Object> configValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : yamlMap.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            configValues.put(key, this.yamlValueToConfigValue(value));
        }
        return configValues;
    }

    private Object yamlValueToConfigValue(Object yamlValue) {
        if (yamlValue instanceof Map) {
            Map yamlMap = (Map)yamlValue;
            return new ConfigSection(this.yamlMapToConfigValues(yamlMap));
        }
        if (yamlValue instanceof List) {
            List yamlList = (List)yamlValue;
            ArrayList<Object> configList = new ArrayList<Object>();
            for (Object element : yamlList) {
                configList.add(this.yamlValueToConfigValue(element));
            }
            return configList;
        }
        return yamlValue;
    }

    public Map<String, Object> configValuesToYamlMap(Map<String, Object> configValues) {
        LinkedHashMap<String, Object> yamlMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : configValues.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            yamlMap.put(key, this.configValueToYamlValue(value));
        }
        return yamlMap;
    }

    private Object configValueToYamlValue(Object configValue) {
        if (configValue instanceof ConfigSection) {
            ConfigSection configSection = (ConfigSection)configValue;
            return this.configValuesToYamlMap(configSection.getInternalValues());
        }
        if (configValue instanceof List) {
            List configList = (List)configValue;
            ArrayList<Object> yamlList = new ArrayList<Object>();
            for (Object configElement : configList) {
                yamlList.add(this.configValueToYamlValue(configElement));
            }
            return yamlList;
        }
        return configValue;
    }

    private Map<?, ?> parseYamlMap(String serializedYamlMap) throws ConfigSyntaxException {
        Object loadedObject;
        try {
            loadedObject = this.yaml.load(serializedYamlMap);
        }
        catch (YAMLException e) {
            throw new ConfigSyntaxException("invalid YAML syntax", e);
        }
        if (loadedObject == null) {
            return null;
        }
        if (loadedObject instanceof Map) {
            return (Map)loadedObject;
        }
        throw new ConfigSyntaxException("invalid YAML syntax", "Top level is not a Map.");
    }

    private String serializeYamlMap(Map<?, ?> yamlMap) {
        String serializedYamlMap = this.yaml.dump(yamlMap);
        if (serializedYamlMap.equals(BLANK_CONFIG)) {
            serializedYamlMap = "";
        }
        return serializedYamlMap;
    }
}

